/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.dm.FilePeerControlAM;
import com.helpsystems.enterprise.peer.FilePeer;

public class FilePeerControlAMImpl
extends AbstractManager
implements FilePeerControlAM {
    private FilePeer filePeer;
    private boolean shutdownStarted;

    FilePeerControlAMImpl(FilePeer filePeer) {
        this.filePeer = filePeer;
        this.setName("ENTERPRISE.FilePeerControlAM");
    }

    public void connectToEnterpriseServer(PeerDescriptor peerDescriptor) throws ActionFailedException {
        PeerID peerID = this.filePeer.getRemotePeerID();
        try {
            this.filePeer.connectToPeer(peerDescriptor, peerID.getInstanceIdentifier());
        }
        catch (Exception exception) {
            throw new ActionFailedException("FilePeer " + peerID + " was unable to connect to " + peerDescriptor, (Throwable)exception);
        }
    }

    public synchronized void finished() throws ActionFailedException {
        if (this.shutdownStarted) {
            return;
        }
        System.out.println("This FilePeer has been instructed to exit.");
        this.shutdownStarted = true;
        final Thread thread = Thread.currentThread();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                FilePeerControlAMImpl.this.doTimedShutdown(thread);
            }
        });
        thread2.start();
    }

    private void doTimedShutdown(Thread thread) {
        try {
            thread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.filePeer.disconnectAll();
        System.exit(0);
    }
}

