/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.server.file.BasicFileAM;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimpleConfig;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.enterprise.peer.FilePeerControlAMImpl;
import com.helpsystems.enterprise.peer.FileTransferInfoAMImpl;
import com.helpsystems.enterprise.peer.NotificationCredentials;
import java.io.Serializable;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class FilePeer
extends SimplePeer {
    private PeerID agentPeerID;

    private FilePeer(String string, SimpleConfig simpleConfig) throws PeerStartupException {
        super(string, simpleConfig);
    }

    public void startup() throws PeerStartupException {
        super.startup();
        BasicFileAM basicFileAM = new BasicFileAM();
        basicFileAM.setName("COMMON.RemoteFileAM");
        ManagerRegistry.registerManager((IAbstractManager)basicFileAM);
        this.addListener(new SimpleEventListener(){

            public void serviceEvent(GenericEvent genericEvent) {
                if (FilePeer.this.agentPeerID == null) {
                    return;
                }
                if (genericEvent instanceof PeerDisconnectEvent) {
                    PeerDescriptor peerDescriptor;
                    PeerID peerID = ((PeerDisconnectEvent)genericEvent).getPeerID();
                    if (peerID.equals((Object)FilePeer.this.agentPeerID)) {
                        FilePeer.exit(4, "Agent " + FilePeer.this.agentPeerID.getPeerDescriptor().findName() + " is no longer available.");
                    }
                    if ((peerDescriptor = peerID.getPeerDescriptor()).getType() == 6) {
                        FilePeer.exit(5, "Enterprise Server " + peerDescriptor + " is no longer available.");
                    }
                }
            }
        });
        ManagerRegistry.registerManager((IAbstractManager)new FilePeerControlAMImpl(this));
        ManagerRegistry.registerManager((IAbstractManager)new FileTransferInfoAMImpl((Peer)this));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            FilePeer.exit(1, "Please specify the agent's port and the instance identifier on the command line.");
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Exception exception) {
            FilePeer.exit(2, "Invalid port specified: " + stringArray[0]);
        }
        SimpleConfig simpleConfig = new SimpleConfig();
        simpleConfig.setListenPort(-1234);
        FilePeer filePeer = null;
        try {
            filePeer = new FilePeer(stringArray[1], simpleConfig);
            filePeer.startup();
        }
        catch (Exception exception) {
            FilePeer.exit(7, "Unable to start the peer", exception);
        }
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.addAddress("localhost");
        peerDescriptor.setPort(n);
        peerDescriptor.setType(4);
        try {
            filePeer.agentPeerID = filePeer.connectToPeer(peerDescriptor, (Serializable)((Object)new NotificationCredentials()));
            ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)filePeer));
        }
        catch (Exception exception) {
            FilePeer.exit(3, "Unable to connect to the Agent.", exception);
        }
    }

    private static void exit(int n, String string) {
        FilePeer.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    public static void captureSignal(String string) {
        Signal signal = new Signal(string);
        SignalHandler signalHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
            }
        };
        Signal.handle(signal, signalHandler);
    }

    static {
        try {
            FilePeer.captureSignal("HUP");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

