/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.util.ProgressListener;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.server.file.FileHandle;
import com.helpsystems.common.server.file.FileHandleOutputStream;
import com.helpsystems.common.server.file.RemoteFile;
import com.helpsystems.common.server.file.RemoteFileAM;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.AgentProxy;
import com.helpsystems.enterprise.core.busobj.UpdateAgentProcess;
import com.helpsystems.enterprise.core.dm.AgentAM;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentStatusAM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class AgentUpdater {
    private static final Logger LOGGER = Logger.getLogger(AgentUpdater.class);
    public static String downloadsDir = "webapps/automate-schedule/download";
    public static final String UPDATE_LOG_FILE = "update.log";
    private static final int MAX_SIMULTANEOUS_AGENT_UPDATES = 5;
    private double progress;
    private Agent agent;
    private RemoteFileAM remoteFileAM;
    private String installer;
    private Throwable updateFailure;
    private ProgressListener progressListener;
    private Properties agentProps = null;
    private Map<String, String> agentEnv;
    private String userName;
    private static Thread updateProcessControllerThread;
    private static BlockingQueue<UpdateAgentProcess> updateProcessQueue;
    private static BlockingQueue<String> limitingQueue;
    private static boolean stopRequested;
    private static boolean processorControllerActive;

    private AgentUpdater(Agent agent, Properties properties, Map<String, String> map, String string) {
        this.agent = agent;
        this.agentProps = properties;
        this.agentEnv = map;
        this.userName = string;
    }

    public String getAgentName() {
        return this.agent.getName();
    }

    public long getAgentOID() {
        return this.agent.getOid();
    }

    private static Agent fetchAgent(long l) throws ActionFailedException {
        AgentDM agentDM = null;
        try {
            agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        }
        catch (Exception exception) {
            AgentUpdater.logAndThrow("Unable to retrieve the AgentDM.", exception);
        }
        Agent agent = null;
        try {
            agent = agentDM.get(l);
        }
        catch (Exception exception) {
            AgentUpdater.logAndThrow("Unable to fetch agent info from the database.", exception);
        }
        if (agent == null) {
            throw new ActionFailedException("Agent ID " + l + " no longer exists.");
        }
        return agent;
    }

    public static AgentUpdater update(long l, String string) throws ActionFailedException {
        Object object;
        Agent agent = AgentUpdater.fetchAgent(l);
        Properties properties = null;
        Map map = null;
        try {
            object = (IPeerInfoManager)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"PEER.PeerInfoManager");
            properties = object.getSystemProperties();
            try {
                map = object.getSystemEnvironment();
            }
            catch (Throwable throwable) {}
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to retrieve the system properties from agent " + agent.getName(), (Throwable)exception);
        }
        object = new AgentUpdater(agent, properties, map, string);
        super.startUpdate();
        return object;
    }

    public static String resolveTempDir() throws ActionFailedException {
        return AgentUpdater.resolveTempDir(System.getProperties(), System.getenv());
    }

    public static String resolveTempDir(long l) throws ActionFailedException {
        Agent agent = AgentUpdater.fetchAgent(l);
        return AgentUpdater.resolveTempDir(agent);
    }

    public static String resolveTempDir(Agent agent) throws ActionFailedException {
        Properties properties = AgentUpdater.fetchSystemProps(agent);
        Map<String, String> map = AgentUpdater.fetchSystemEnv(agent);
        return AgentUpdater.resolveTempDir(properties, map);
    }

    private static String resolveTempDir(Properties properties, Map<String, String> map) throws ActionFailedException {
        String string = null;
        if (map != null) {
            string = map.get("AUTO_UPDATE_DIR");
        }
        if (string == null) {
            string = AgentUpdater.fixPath(properties.getProperty("java.io.tmpdir")) + "Skybot-auto-update";
        }
        return string;
    }

    public static String resolveScriptName() throws ActionFailedException {
        return AgentUpdater.resolveScriptName(System.getProperties(), System.getenv());
    }

    private static String resolveScriptName(Properties properties, Map<String, String> map) throws ActionFailedException {
        String string = null;
        if (map != null) {
            string = map.get("AUTO_UPDATE_SCRIPT");
        }
        if (string != null) {
            return string;
        }
        string = "auto-update";
        String string2 = properties.getProperty("os.name").toLowerCase();
        string = string2.indexOf("windows") > -1 ? string + ".bat" : string + ".sh";
        return string;
    }

    public static Properties fetchSystemProps(Agent agent) throws ActionFailedException {
        Object var1_1 = null;
        try {
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"PEER.PeerInfoManager");
            return iPeerInfoManager.getSystemProperties();
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to retrieve the system properties from agent " + agent.getName(), (Throwable)exception);
        }
    }

    public static Map<String, String> fetchSystemEnv(Agent agent) throws ActionFailedException {
        try {
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManagerStartsWith((BasicIdentifier)agent, (String)"PEER.PeerInfoManager");
            try {
                return iPeerInfoManager.getSystemEnvironment();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to retrieve the system environment from agent " + agent.getName(), (Throwable)exception);
        }
    }

    private void startUpdate() throws ActionFailedException {
        RelMod relMod;
        AgentStatusAM agentStatusAM;
        AgentProxy[] agentProxyArray = null;
        try {
            agentStatusAM = (AgentStatusAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentStatusAM");
            agentProxyArray = agentStatusAM.getStatus(new AgentProxy[]{this.agent});
        }
        catch (Exception exception) {
            AgentUpdater.logAndThrow("Unable to access the agent status information", exception);
        }
        if (agentProxyArray == null || agentProxyArray.length == 0 || agentProxyArray[0] == null || agentProxyArray[0].getRuntimeState() != 1) {
            throw new ActionFailedException("The agent '" + this.agent.getName() + "' is not active.");
        }
        agentStatusAM = agentProxyArray[0];
        RelMod relMod2 = RelMod.parse((String)this.agent.getVersion());
        if ((relMod2 = new RelMod(relMod2.getRelease(), relMod2.getModification())).compareTo((Object)(relMod = new RelMod(2, 1))) >= 0) {
            throw new ActionFailedException("The agent '" + agentStatusAM.getName() + "' is at version " + this.agent.getVersion() + " and does not support auto-update.");
        }
        String string = null;
        String string2 = null;
        String string3 = agentStatusAM.getOperatingSystem().toLowerCase();
        if (string3.indexOf("windows") > -1) {
            this.installer = "setupAutomateScheduleAgent.exe";
            string = AgentUpdater.resolveScriptName(this.agentProps, this.agentEnv);
            string2 = this.installer + " /S\r\n" + "echo Automatic update installer for agent version " + this.agent.getVersion().toString() + " exited with code: %ERRORLEVEL% > update.log\r\ndate /t >> update.log\r\ntime /t >> update.log\r\nexit\r\n";
        } else if (string3.indexOf("linux") > -1 || string3.indexOf("hp-ux") > -1 || string3.indexOf("sunos") > -1 || string3.indexOf("mac") > -1 || string3.indexOf("aix") > -1) {
            this.installer = "setupAutomateScheduleAgent.tar";
            string = AgentUpdater.resolveScriptName(this.agentProps, this.agentEnv);
            string2 = "#!/bin/sh\ntar xf " + this.installer + "\n" + "JAVA_HOME=" + this.agentProps.get("java.home") + "\n" + "export JAVA_HOME\n" + "exec ./automatescheduleinstall/agentInstall -d \"" + this.agentProps.getProperty("user.dir") + "\" -q -useexec\n";
        } else {
            throw new ActionFailedException("Cannot update the agent '" + agentStatusAM.getName() + "' running on " + string3);
        }
        String string4 = AgentUpdater.resolveTempDir(this.agentProps, this.agentEnv);
        RemoteFile remoteFile = null;
        try {
            this.remoteFileAM = (RemoteFileAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.agent, (String)"COMMON.RemoteFileAM");
            remoteFile = this.remoteFileAM.get(null, string4);
        }
        catch (Exception exception) {
            AgentUpdater.logAndThrow("Unable to access the file system on the agent " + this.agent.getName(), exception);
        }
        if (!remoteFile.exists()) {
            try {
                this.remoteFileAM.mkdir(null, string4);
                remoteFile = this.remoteFileAM.get(UserIdentity.NO_USER_SPECIFIED, string4);
            }
            catch (Exception exception) {
                throw new ActionFailedException("Unable to update agent '" + agentStatusAM.getName() + "', the directory '" + string4 + "' could not be created.", (Throwable)exception);
            }
        }
        if (!remoteFile.exists() || !remoteFile.isDirectory()) {
            throw new ActionFailedException("Unable to update agent '" + agentStatusAM.getName() + "', the directory '" + string4 + "' does not exist.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        try {
            this.sendFile(string, byteArrayInputStream, -1.0);
        }
        catch (Exception exception) {
            AgentUpdater.logAndThrow("Unable to transfer files to the agent " + this.agent.getName(), exception);
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    AgentUpdater.this.doAsynchUpdate();
                }
                catch (Exception exception) {
                    LOGGER.error((Object)"Error running Agent update.", (Throwable)exception);
                }
                finally {
                    if (!AgentUpdater.getLimitingQueue().remove(AgentUpdater.this.agent.getHardwareHash())) {
                        LOGGER.warn((Object)("Failed to remove Update Process for Agent " + AgentUpdater.this.agent.getName() + " with HardwareHash " + AgentUpdater.this.agent.getHardwareHash() + " from the limiting queue."));
                    } else {
                        LOGGER.debug((Object)("Update Process for Agent " + AgentUpdater.this.agent.getName() + " with HardwareHash " + AgentUpdater.this.agent.getHardwareHash() + " removed from the limiting queue."));
                    }
                    LOGGER.debug((Object)("The limiting queue size = " + AgentUpdater.getLimitingQueue().size()));
                }
            }
        };
        UpdateAgentProcess updateAgentProcess = new UpdateAgentProcess(this.agent.getName(), this.agent.getHardwareHash(), thread);
        try {
            this.addUpdateToQueue(updateAgentProcess);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ActionFailedException("The update for Agent " + this.agent.getName() + " with HardwareHash " + this.agent.getHardwareHash() + " will not be run.", (Throwable)illegalStateException);
        }
    }

    private void dumpAgentProps() {
        for (Object object : this.agentProps.keySet()) {
            LOGGER.debug((Object)("AgentProps -> " + object + ":" + this.agentProps.getProperty((String)object)));
        }
    }

    private void addUpdateToQueue(UpdateAgentProcess updateAgentProcess) throws IllegalStateException {
        if (AgentUpdater.getLimitingQueue().contains(updateAgentProcess.getHardwareHash())) {
            String string = "An update for Hardware Hash " + updateAgentProcess.getHardwareHash() + " is already in progress.";
            LOGGER.warn((Object)string);
            throw new IllegalStateException(string);
        }
        AgentUpdater.getUpdateProcessQueue().add(updateAgentProcess);
        LOGGER.debug((Object)("UpdateAgentProcess for Agent " + updateAgentProcess.getAgentName() + " with Hardware Hash " + updateAgentProcess.getHardwareHash() + " added to the UpdateProcess queue."));
    }

    public static void startAgentUpdateController() {
        if (updateProcessControllerThread == null || !updateProcessControllerThread.isAlive()) {
            updateProcessControllerThread = new Thread(new UpdateProcessController());
            updateProcessControllerThread.setName("AgentUpdateController");
            updateProcessControllerThread.start();
            processorControllerActive = true;
        }
    }

    private static BlockingQueue<String> getLimitingQueue() {
        if (limitingQueue == null) {
            limitingQueue = new LinkedBlockingQueue<String>(5);
        }
        return limitingQueue;
    }

    private static BlockingQueue<UpdateAgentProcess> getUpdateProcessQueue() {
        if (updateProcessQueue == null) {
            updateProcessQueue = new LinkedBlockingQueue<UpdateAgentProcess>();
        }
        return updateProcessQueue;
    }

    private static String fixPath(String string) {
        String string2 = string;
        if (!string.endsWith("/")) {
            string2 = string + "/";
        }
        return string2;
    }

    private String getRemotePath(String string) throws ActionFailedException {
        String string2 = AgentUpdater.resolveTempDir(this.agentProps, this.agentEnv);
        return AgentUpdater.fixPath(string2) + string;
    }

    private void sendFile(String string, InputStream inputStream, double d) throws Exception {
        String string2 = this.getRemotePath(string);
        RemoteFile remoteFile = this.remoteFileAM.get(null, string2);
        if (remoteFile.exists()) {
            try {
                this.remoteFileAM.delete(UserIdentity.NO_USER_SPECIFIED, string2);
            }
            catch (Exception exception) {
                throw new ActionFailedException("Unable to delete the existing file " + string2 + " on agent " + this.agent.getName(), (Throwable)exception);
            }
        }
        FileHandle fileHandle = null;
        FileHandleOutputStream fileHandleOutputStream = null;
        try {
            int n;
            LOGGER.debug((Object)("Start of sending file " + string2));
            fileHandle = this.remoteFileAM.getHandle(UserIdentity.NO_USER_SPECIFIED, string2, "rw");
            fileHandleOutputStream = new FileHandleOutputStream(fileHandle);
            byte[] byArray = new byte[20000];
            double d2 = 0.0;
            while ((n = inputStream.read(byArray)) >= 1) {
                fileHandleOutputStream.write(byArray, 0, n);
                d2 += (double)n;
                if (!(d > 0.0)) continue;
                this.progress = d2 / d;
                if (this.progressListener == null) continue;
                this.progressListener.progressUpdated(this.progress);
            }
            LOGGER.debug((Object)("End of sending file " + string2));
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to transfer " + string + " to " + this.agent.getName(), (Throwable)exception);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileHandleOutputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileHandle.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean doAsynchUpdate() {
        RemoteFile remoteFile;
        String[] stringArray;
        String string;
        block16: {
            FileInputStream fileInputStream;
            block15: {
                String string2;
                Object object;
                fileInputStream = null;
                Thread.currentThread().setName("Transferring " + this.installer + " to agent " + this.agent.getName());
                string = downloadsDir + '/' + this.installer;
                stringArray = this.getRemotePath(this.installer);
                remoteFile = this.remoteFileAM.get(null, (String)stringArray);
                boolean bl = true;
                if (remoteFile.exists() && ((String)(object = MD5.hashFile((String)string))).equalsIgnoreCase(string2 = this.remoteFileAM.md5sum(UserIdentity.NO_USER_SPECIFIED, (String)stringArray))) {
                    bl = false;
                }
                if (!bl) break block15;
                object = new File(string);
                fileInputStream = new FileInputStream((File)object);
                this.sendFile(this.installer, fileInputStream, ((File)object).length());
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            break block16;
            catch (Throwable throwable) {
                try {
                    String string3 = "Unable to transfer " + this.installer + " to the Agent " + this.agent.getName();
                    this.doErrorProcess(string3, throwable);
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            string = (AgentAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.agent, (String)"ENTERPRISE.AgentAM");
            string.shutdownAndUpdate();
        }
        catch (Throwable throwable) {
            stringArray = "Unable to update and restart the agent " + this.agent.getName();
            this.doErrorProcess((String)stringArray, throwable);
            return false;
        }
        string = "Agent " + this.agent.getName() + " is updating itself and will restart when completed.";
        if (this.progressListener != null) {
            this.progressListener.progressCompleted(0, string, null);
        }
        stringArray = new String[]{String.valueOf(this.getAgentName())};
        remoteFile = RosettaMsg.AGENT_UPDATE_STARTED.newLogEntry(stringArray);
        remoteFile.setAgentID(this.getAgentOID());
        ScheduleLogger.write((ScheduleLogEntry)remoteFile);
        LOGGER.info((Object)remoteFile.getMessageText());
        return true;
    }

    private void doErrorProcess(String string, Throwable throwable) {
        String[] stringArray = new String[]{String.valueOf(this.getAgentName()), this.userName};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.AGENT_UPDATE_FAILED.newLogEntry(stringArray);
        scheduleLogEntry.setAgentID(this.getAgentOID());
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        LOGGER.error((Object)scheduleLogEntry);
        LOGGER.error((Object)string, throwable);
        this.updateFailure = throwable;
        if (this.progressListener != null) {
            this.progressListener.progressCompleted(-1, string, throwable);
        }
    }

    static void logAndThrow(String string, Throwable throwable) throws ActionFailedException {
        LOGGER.debug((Object)string, throwable);
        throw new ActionFailedException(string, throwable);
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public static void stop() {
        stopRequested = true;
    }

    static {
        updateProcessQueue = null;
        limitingQueue = null;
        stopRequested = false;
    }

    private static class UpdateProcessController
    implements Runnable {
        private boolean readyToShutDown = false;

        private UpdateProcessController() {
        }

        @Override
        public void run() {
            try {
                LOGGER.debug((Object)"The UpdateProcessController has started.");
                while (!this.readyToShutDown) {
                    this.dequeue();
                }
            }
            catch (Throwable throwable) {
                LOGGER.warn((Object)"The UpdateProcessController has encountered a severe error. No more Agent Update Events will be processed until the server is restarted.", throwable);
            }
            finally {
                LOGGER.debug((Object)"The UpdateProcessController has ended.");
                processorControllerActive = false;
            }
        }

        private void dequeue() {
            block2: {
                try {
                    LOGGER.debug((Object)"Waiting on an UpdateAgentProcess...");
                    UpdateAgentProcess updateAgentProcess = (UpdateAgentProcess)AgentUpdater.getUpdateProcessQueue().take();
                    AgentUpdater.getLimitingQueue().put(updateAgentProcess.getHardwareHash());
                    LOGGER.debug((Object)("Update Process for Agent " + updateAgentProcess.getAgentName() + " with HardwareHash " + updateAgentProcess.getHardwareHash() + " added to the limiting queue."));
                    LOGGER.debug((Object)("The limiting queue size = " + AgentUpdater.getLimitingQueue().size()));
                    updateAgentProcess.getTheThread().start();
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error((Object)"UpdateProcessController was interrupted.", (Throwable)interruptedException);
                    if (!AgentUpdater.getUpdateProcessQueue().isEmpty()) break block2;
                    this.readyToShutDown = true;
                }
            }
        }
    }
}

