/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.access.CcsidManager;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OS400ObjectNameValidator {
    private static final String validFirstChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@";
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400ObjectNameValidator.class);
    private static final byte[] validFirstBytes = CcsidManager.charConverterCcsid37().stringToByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@");
    private static final String validCNAMEChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@0123456789";
    private static final String validSNAMEChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@0123456789_";
    private static final String validNAMEChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@0123456789_.";
    private static final byte[] validNAMEBytes = CcsidManager.charConverterCcsid37().stringToByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@0123456789_.");
    private static final byte[] validSNAMEBytes = CcsidManager.charConverterCcsid37().stringToByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@0123456789_");
    private static final byte[] validCNAMEBytes = CcsidManager.charConverterCcsid37().stringToByteArray("ABCDEFGHIJKLMNOPQRSTUVWXYZ$#@0123456789");
    private static Set<Character> validCharsForGui;
    private static CcsidManager ccsidManager;

    private OS400ObjectNameValidator() {
    }

    public static String validateName(String string, boolean bl) {
        return OS400ObjectNameValidator.validateName(string, bl, "The name");
    }

    public static String validateName(String string, boolean bl, String string2) {
        return OS400ObjectNameValidator.doValidation(string, bl, string2, 10, validNAMEBytes);
    }

    public static String validateNAME(String string, boolean bl, String string2) {
        return OS400ObjectNameValidator.doValidation(string, bl, string2, 256, validNAMEBytes);
    }

    public static String validateSNAME(String string, boolean bl, String string2) {
        return OS400ObjectNameValidator.doValidation(string, bl, string2, 256, validSNAMEBytes);
    }

    public static String validateCNAME(String string, boolean bl, String string2) {
        return OS400ObjectNameValidator.doValidation(string, bl, string2, 256, validCNAMEBytes);
    }

    private static String doValidation(String string, boolean bl, String string2, int n, byte[] byArray) {
        boolean bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException(rbh.getText("name_parameter_is_null"));
        }
        if ((string3 = string3.trim()).length() < 1) {
            throw new IllegalArgumentException(string2 + " " + rbh.getText("cannot_be_blank"));
        }
        if (string3.length() > n) {
            throw new IllegalArgumentException(string2 + " (" + string + ") " + rbh.getMsg("exceeds_n_characters", (Object)n));
        }
        if (string3.length() > 3 && string3.startsWith("\"") && string3.endsWith("\"")) {
            return string3;
        }
        if (bl && string3.endsWith("*") && string3.length() > 1) {
            string3 = string3.substring(0, string3.length() - 1);
            bl2 = true;
        }
        String string4 = string3.startsWith("\"") && string3.endsWith("\"") && string3.length() > 2 ? string3.substring(1, string3.length() - 1) : string3.toUpperCase();
        byte[] byArray2 = ccsidManager.charConverterForGui().stringToByteArray(string4);
        byte by = byArray2[0];
        if (!OS400ObjectNameValidator.isInArray(validFirstBytes, by)) {
            String string5 = rbh.getMsg("is_invalid", (Object)string2, (Object)string, (Object)ccsidManager.charConverterForGui().byteArrayToString(validFirstBytes));
            throw new IllegalArgumentException(string5);
        }
        for (int i = 1; i < byArray2.length; ++i) {
            if (OS400ObjectNameValidator.isInArray(byArray, byArray2[i])) continue;
            String string6 = rbh.getMsg("contains_an", (Object)string2, (Object)string, (Object)ccsidManager.charConverterForGui().byteArrayToString(byArray));
            throw new IllegalArgumentException(string6);
        }
        if (bl2) {
            return string4 + "*";
        }
        return string4;
    }

    public static String validateQualifiedName(String string, String[] stringArray, boolean bl) {
        return OS400ObjectNameValidator.validateQualifiedName(string, stringArray, bl, "The qualified name");
    }

    public static String validateQualifiedName(String string, String[] stringArray, boolean bl, String string2) {
        if (string == null) {
            throw new NullPointerException(rbh.getText("qualified_name_parameter_cannot_be_null"));
        }
        String string3 = string.trim();
        if (string3.length() < 1) {
            throw new IllegalArgumentException(string2 + " " + rbh.getText("cannot_be_blank"));
        }
        if (string3.length() > 21) {
            throw new IllegalArgumentException(string2 + " (" + string3 + rbh.getText("exceeds_21_characters"));
        }
        String[] stringArray2 = string.split("/");
        if (stringArray2.length != 2) {
            throw new IllegalArgumentException(string2 + " (" + string + rbh.getText("does_not_contain"));
        }
        String string4 = stringArray2[0];
        String string5 = stringArray2[1];
        boolean bl2 = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string4.equals(stringArray[i])) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2) {
            if (string4.startsWith("*")) {
                throw new IllegalArgumentException(string4 + " " + rbh.getText("is_not_a_supported"));
            }
            if (string4.length() > 3 && string4.startsWith("\"") && string4.endsWith("\"")) {
                throw new IllegalArgumentException(rbh.getText("library_name_cannot"));
            }
            string4 = OS400ObjectNameValidator.validateName(string4, false);
        }
        string5 = OS400ObjectNameValidator.validateName(string5, false);
        return string4 + "/" + string5;
    }

    public static Set<Character> getAllPossibleValidObjectOrLibraryNameCharacters() {
        Set<Character> set = OS400ObjectNameValidator.getAllValidObjectNameCharacters();
        HashSet<Character> hashSet = new HashSet<Character>(set);
        hashSet.add(new Character('/'));
        hashSet.add(new Character('*'));
        return Collections.unmodifiableSet(hashSet);
    }

    public static Set<Character> getAllValidObjectNameCharacters() {
        if (validCharsForGui == null) {
            String string = ccsidManager.charConverterForGui().byteArrayToString(validNAMEBytes);
            char[] cArray = string.toCharArray();
            HashSet<Character> hashSet = new HashSet<Character>();
            for (int i = 0; i < cArray.length; ++i) {
                hashSet.add(new Character(cArray[i]));
            }
            validCharsForGui = Collections.unmodifiableSet(hashSet);
        }
        return validCharsForGui;
    }

    private static boolean isInArray(byte[] byArray, byte by) {
        return Arrays.binarySearch(byArray, by) > -1;
    }

    static {
        Arrays.sort(validFirstBytes);
        Arrays.sort(validNAMEBytes);
        Arrays.sort(validSNAMEBytes);
        Arrays.sort(validCNAMEBytes);
        ccsidManager = new CcsidManager();
    }
}

