/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.busobj;

import com.helpsystems.common.as400.prompter.busobj.ControlCondition;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.Vector;

public class PromptControl {
    public static final int NONE = 0;
    public static final int AND = 1;
    public static final int OR = 2;
    protected String keyword;
    protected int numberTrue;
    protected int relOp;
    protected Vector<ControlCondition> conditionList = new Vector();
    private int booleanControl;

    public void addCondition(ControlCondition controlCondition) {
        this.conditionList.add(controlCondition);
    }

    public ControlCondition[] getConditions() {
        ControlCondition[] controlConditionArray = new ControlCondition[this.conditionList.size()];
        this.conditionList.toArray(controlConditionArray);
        return controlConditionArray;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public int getNumberTrue() {
        return this.numberTrue;
    }

    public int getOperator() {
        return this.relOp;
    }

    public void setKeyword(String string) {
        this.keyword = string;
    }

    public void setNumberTrue(int n) {
        this.numberTrue = n;
    }

    public void setOperator(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                this.relOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("The value passed in  is not valid.");
            }
        }
    }

    public int getBooleanControl() {
        return this.booleanControl;
    }

    public void setBooleanControl(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.booleanControl = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid boolean type: " + n);
            }
        }
    }

    public static int parseBooleanControl(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Boolean control", (String)string);
        if ("AND".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("OR".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("NONE".equalsIgnoreCase(string)) {
            return 0;
        }
        throw new IllegalArgumentException("Invalid boolean type: " + string);
    }
}

