/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.filter;

import com.helpsystems.common.as400.util.OS400ObjectValidator;
import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.util.ResourceBundleHandler;

public class FilterFieldOS400QualifiedObject
extends AbstractFilterField {
    private static final long serialVersionUID = 6692379294709916804L;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(FilterFieldOS400QualifiedObject.class);
    private String[] stringOperators = new String[]{"0"};
    private String[] specialValues = new String[]{"*ALL", "*ALLUSR", "*CURLIB", "*LIBL", "*USRLIBL"};
    private int maxLength = 21;

    public FilterFieldOS400QualifiedObject() {
    }

    public FilterFieldOS400QualifiedObject(String string, String string2) {
        super(string, string2, 0);
        this.setOperatorArray(this.stringOperators);
    }

    public FilterFieldOS400QualifiedObject(String string, String string2, String[] stringArray) {
        super(string, string2, 0);
        this.setOperatorArray(this.stringOperators);
        this.specialValues = stringArray;
    }

    public boolean valid(int n, Object object) {
        String string = null;
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(rbh.getMsg("not_a_string", (Object)this.displayName));
        }
        string = (String)object;
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException(rbh.getMsg("require_value", (Object)this.displayName));
        }
        if (string.indexOf(" ") > -1) {
            throw new IllegalArgumentException(rbh.getMsg("no_embedded_spaces", (Object)this.displayName));
        }
        if (string.length() > this.maxLength) {
            throw new IllegalArgumentException(rbh.getMsg("exceed_max", (Object)this.displayName, (Object)String.valueOf(this.maxLength)));
        }
        string = OS400ObjectValidator.validateQualifiedName(string, this.specialValues, false);
        return true;
    }

    public int getStringCase() {
        return 1;
    }
}

