/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.as400.busobj.OS400SpooledFileProxy;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.Serializable;
import java.util.Date;

public class OS400SpooledFile
extends OS400SpooledFileProxy {
    private static final long serialVersionUID = 8617256773522910274L;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)OS400SpooledFile.class.getName());
    public static final int COPIES_LEFT_TO_PRINT_MINIMUM = 1;
    public static final int COPIES_LEFT_TO_PRINT_MAXIMUM = 255;
    public static final int USER_DATA_LENGTH_MAXIMUM = 10;
    public static final int OUTPUT_QUEUE_NAME_LENGTH_MAXIMUM = 10;
    public static final int LIBRARY_NAME_LENGTH_MAXIMUM = 10;
    public static final int FORM_TYPE_LENGTH_MAXIMUM = 10;
    public static final int OUTPUT_PRIORITY_MINIMUM = 1;
    public static final int OUTPUT_PRIORITY_MAXIMUM = 9;
    public static final int FILE_BECOMES_AVAILABLE_IMMEDIATE = 0;
    public static final int FILE_BECOMES_AVAILABLE_FILE_END = 1;
    public static final int FILE_BECOMES_AVAILABLE_JOB_END = 2;
    public static final int FORM_FEED_CONTINUOUS = 0;
    public static final int FORM_FEED_CONTINUOUS_SECOND = 1;
    public static final int FORM_FEED_CUT = 2;
    public static final int FORM_FEED_AUTOCUT = 3;
    public static final int FORM_FEED_DEVICE = 4;
    public static final int PAGE_RANGE_END_LAST_PAGE = 0;
    public static final int PAGE_RANGE_START_END_PAGE = -1;
    public static final int PAGE_RANGE_START_FIRST_PAGE = 1;
    public static final int PAGE_SIZE_MEASUREMENT_METHOD_ROW_COLUMN = 0;
    public static final int PAGE_SIZE_MEASUREMENT_METHOD_UNIT_OF_MEASURE = 1;
    public static final int PRINTER_DEVICE_TYPE_SCS = 0;
    public static final int PRINTER_DEVICE_TYPE_IPDS = 1;
    public static final int PRINTER_DEVICE_TYPE_AFPDS = 2;
    public static final int PRINTER_DEVICE_TYPE_LINE = 3;
    public static final int PRINTER_DEVICE_TYPE_AFPDSLINE = 4;
    public static final int PRINTER_DEVICE_TYPE_ASCII = 5;
    public static final int PRINT_QUALITY_STANDARD = 0;
    public static final int PRINT_QUALITY_DRAFT = 1;
    public static final int PRINT_QUALITY_NEAR_LETTER_QUALITY = 2;
    public static final int PRINT_QUALITY_DEVICE_DESCRIPTION = 3;
    public static final int PRINT_QUALITY_FAST_DRAFT = 4;
    public static final int RECORD_LENGTH_RECORD_FORMAT = -1;
    public static final int RECORD_LENGTH_PAGE_WIDTH = 0;
    public static final int RESTART_PRINTING_START_PAGE = -1;
    public static final int RESTART_PRINTING_END_PAGE = -2;
    public static final int RESTART_PRINTING_NEXT_PAGE = -3;
    public static final int SOURCE_DRAWER_ENVELOPE = -1;
    public static final int SOURCE_DRAWER_FORM_DEFINITION = -2;
    public static final int UNIT_OF_MEASURE_INCH = 0;
    public static final int UNIT_OF_MEASURE_CM = 1;
    private String accountingCode;
    private boolean alignPage;
    private float charactersPerInch;
    private Date dateFileLastUsed;
    private String deviceType;
    private int fileBecomesAvailable;
    private int formFeed;
    private boolean holdBeforeWritten;
    private int lastPagePrinted;
    private float linesPerInch;
    private int overflowLineNumber;
    private boolean pageCountEstimate;
    private int pageRangeStart;
    private int pageRangeEnd;
    private float pageSizeLenth;
    private float pageSizeWidth;
    private int pageSizeMeasurementMethod;
    private int printerDeviceType;
    private String printerFile;
    private int printQuality;
    private String programThatOpenedFile;
    private int recordLength;
    private int restartPrinting;
    private boolean saveAfterWritten;
    private int sourceDrawer;
    private String systemCreatedOn;
    private int totalCopies;
    private int unitOfMeasure;

    public String getAccountingCode() {
        return this.accountingCode;
    }

    public void setAccountingCode(String string) {
        this.accountingCode = string;
    }

    public boolean isAlignPage() {
        return this.alignPage;
    }

    public void setAlignPage(boolean bl) {
        this.alignPage = bl;
    }

    public float getCharactersPerInch() {
        return this.charactersPerInch;
    }

    public void setCharactersPerInch(float f) {
        this.charactersPerInch = f;
    }

    @Override
    public void setCopiesLeftToPrint(int n) {
        ValidationHelper.validateBounds((String)"Copies ", (long)1L, (long)255L, (long)n);
        super.setCopiesLeftToPrint(n);
    }

    public Date getDateFileLastUsed() {
        return this.dateFileLastUsed;
    }

    public void setDateFileLastUsed(Date date) {
        this.dateFileLastUsed = date;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String string) {
        this.deviceType = string;
    }

    public int getFileBecomesAvailable() {
        return this.fileBecomesAvailable;
    }

    public String getFileBecomesAvailableAsString() {
        String string = null;
        switch (this.fileBecomesAvailable) {
            case 0: {
                string = "*IMMED";
                break;
            }
            case 1: {
                string = "*FILEEND";
                break;
            }
            case 2: {
                string = "*JOBEND";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void setFileBecomesAvailable(int n) {
        this.fileBecomesAvailable = n;
    }

    public int getFormFeed() {
        return this.formFeed;
    }

    public String getFormFeedAsString() {
        String string = null;
        switch (this.formFeed) {
            case 0: {
                string = "*CONT";
                break;
            }
            case 1: {
                string = "*CONT2";
                break;
            }
            case 2: {
                string = "*CUT";
                break;
            }
            case 3: {
                string = "*AUTOCUT";
                break;
            }
            case 4: {
                string = "*DEVD";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void setFormFeed(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(rbh.getText("invalid_form_feed"));
            }
        }
        this.formFeed = n;
    }

    @Override
    public void setFormType(String string) {
        ValidationHelper.validateLength((String)"Form Type", (int)10, (String)string);
        super.setFormType(string);
    }

    public boolean isHoldBeforeWritten() {
        return this.holdBeforeWritten;
    }

    public void setHoldBeforeWritten(boolean bl) {
        this.holdBeforeWritten = bl;
    }

    public int getLastPagePrinted() {
        return this.lastPagePrinted;
    }

    public void setLastPagePrinted(int n) {
        this.lastPagePrinted = n;
    }

    public float getLinesPerInch() {
        return this.linesPerInch;
    }

    public void setLinesPerInch(float f) {
        this.linesPerInch = f;
    }

    public int getOverflowLineNumber() {
        return this.overflowLineNumber;
    }

    public void setOverflowLineNumber(int n) {
        this.overflowLineNumber = n;
    }

    @Override
    public void setOutputPriority(int n) {
        ValidationHelper.validateBounds((String)"Output Priority", (long)1L, (long)9L, (long)n);
        super.setOutputPriority(n);
    }

    @Override
    public void setOutputQueue(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Output Queue", (String)string);
        ValidationHelper.validateLength((String)"Output Queue", (int)10, (String)string);
        super.setOutputQueue(string);
    }

    @Override
    public void setOutputQueueLibrary(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Output Queue Library", (String)string);
        ValidationHelper.validateLength((String)"Output Queue Library", (int)10, (String)string);
        super.setOutputQueueLibrary(string);
    }

    public boolean isPageCountEstimate() {
        return this.pageCountEstimate;
    }

    public void setPageCountEsimate(boolean bl) {
        this.pageCountEstimate = bl;
    }

    public float getPageSizeLenth() {
        return this.pageSizeLenth;
    }

    public void setPageSizeLenth(float f) {
        this.pageSizeLenth = f;
    }

    public int getPageSizeMeasurementMethod() {
        return this.pageSizeMeasurementMethod;
    }

    public String getPageSizeMeasurementMethodAsString() {
        String string = null;
        switch (this.pageSizeMeasurementMethod) {
            case 0: {
                string = "*ROWCOL";
                break;
            }
            case 1: {
                string = "*UOM";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void setPageSizeMeasurementMethod(int n) {
        this.pageSizeMeasurementMethod = n;
    }

    public float getPageSizeWidth() {
        return this.pageSizeWidth;
    }

    public void setPageSizeWidth(float f) {
        this.pageSizeWidth = f;
    }

    public int getPageRangeEnd() {
        return this.pageRangeEnd;
    }

    public String getPageRangeEndAsString() {
        String string = null;
        switch (this.pageRangeEnd) {
            case 0: {
                string = "*END";
                break;
            }
            default: {
                string = Integer.toString(this.pageRangeEnd);
            }
        }
        return string;
    }

    public void setPageRangeEnd(int n) {
        if (n != 0 && n < 1) {
            throw new IllegalArgumentException(rbh.getText("page_end_cannot_less_than_one"));
        }
        this.pageRangeEnd = n;
    }

    public int getPageRangeStart() {
        return this.pageRangeStart;
    }

    public String getPageRangeStartAsString() {
        String string = null;
        switch (this.pageRangeStart) {
            case -1: {
                string = "*ENDPAGE";
                break;
            }
            default: {
                string = Integer.toString(this.pageRangeStart);
            }
        }
        return string;
    }

    public void setPageRangeStart(int n) {
        if (n != -1 && n != 1 && n < 1) {
            throw new IllegalArgumentException(rbh.getText("page_start_cannot_less_than_one"));
        }
        this.pageRangeStart = n;
    }

    public int getPrinterDeviceType() {
        return this.printerDeviceType;
    }

    public String getPrinterDeviceTypeAsString() {
        String string = null;
        switch (this.printerDeviceType) {
            case 0: {
                string = "*SCS";
                break;
            }
            case 1: {
                string = "*IPDS";
                break;
            }
            case 2: {
                string = "*AFPDS";
                break;
            }
            case 3: {
                string = "*LINE";
                break;
            }
            case 4: {
                string = "*AFPDSLINE";
                break;
            }
            case 5: {
                string = "*USERASCII";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void setPrinterDeviceType(int n) {
        this.printerDeviceType = n;
    }

    public String getPrinterFile() {
        return this.printerFile;
    }

    public void setPrinterFile(String string) {
        this.printerFile = string;
    }

    public int getPrintQuality() {
        return this.printQuality;
    }

    public String getPrintQualityAsString() {
        String string = null;
        switch (this.printQuality) {
            case 0: {
                string = "*STD";
                break;
            }
            case 1: {
                string = "*DRAFT";
                break;
            }
            case 2: {
                string = "*NLQ";
                break;
            }
            case 3: {
                string = "*DEVD";
                break;
            }
            case 4: {
                string = "*FASTDRAFT";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void setPrintQuality(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException(rbh.getText("invalid_print_quality"));
            }
        }
        this.printQuality = n;
    }

    public String getProgramThatOpenedFile() {
        return this.programThatOpenedFile;
    }

    public void setProgramThatOpenedFile(String string) {
        this.programThatOpenedFile = string;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public String getRecordLengthAsString() {
        String string = null;
        switch (this.recordLength) {
            case -1: {
                string = "*RCDFMT";
                break;
            }
            case 0: {
                string = "Page Width";
                break;
            }
            default: {
                string = Integer.toString(this.recordLength);
            }
        }
        return string;
    }

    public void setRecordLength(int n) {
        this.recordLength = n;
    }

    public int getRestartPrinting() {
        return this.restartPrinting;
    }

    public String getRestartPrintingAsString() {
        String string = null;
        switch (this.restartPrinting) {
            case -1: {
                string = "*STRPAGE";
                break;
            }
            case -2: {
                string = "*ENDPAGE";
                break;
            }
            case -3: {
                string = "*NEXT";
                break;
            }
            default: {
                string = Integer.toString(this.restartPrinting);
            }
        }
        return string;
    }

    public void setRestartPrinting(int n) {
        if (n != -1 && n != -2 && n != -3 && n < 1) {
            throw new IllegalArgumentException(rbh.getText("restart_must_be_greater_than_zero"));
        }
        this.restartPrinting = n;
    }

    public boolean isSaveAfterWritten() {
        return this.saveAfterWritten;
    }

    public void setSaveAfterWritten(boolean bl) {
        this.saveAfterWritten = bl;
    }

    public int getSourceDrawer() {
        return this.sourceDrawer;
    }

    public String getSourceDrawerAsString() {
        String string = null;
        switch (this.sourceDrawer) {
            case -1: {
                string = "*E1";
                break;
            }
            case -2: {
                string = "*FORMDF";
                break;
            }
            default: {
                string = Integer.toString(this.sourceDrawer);
            }
        }
        return string;
    }

    public void setSourceDrawer(int n) {
        this.sourceDrawer = n;
    }

    public String getSystemCreatedOn() {
        return this.systemCreatedOn;
    }

    public void setSystemCreatedOn(String string) {
        this.systemCreatedOn = string;
    }

    public int getTotalCopies() {
        return this.totalCopies;
    }

    public void setTotalCopies(int n) {
        this.totalCopies = n;
    }

    public int getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public String getUnitOfMeasureAsString() {
        String string = null;
        switch (this.unitOfMeasure) {
            case 0: {
                string = "*INCH";
                break;
            }
            case 1: {
                string = "*CM";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public void setUnitOfMeasure(int n) {
        this.unitOfMeasure = n;
    }

    @Override
    public void setUserData(String string) {
        ValidationHelper.validateLength((String)"User Data", (int)10, (String)string);
        super.setUserData(string);
    }

    public void validate() {
        this.validatePageRange();
        this.validateRestartPrinting();
    }

    private void validatePageRange() {
        int n = this.getTotalPages();
        int n2 = this.getPageRangeStart();
        int n3 = this.getPageRangeEnd();
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == -1 || n2 == 1) {
            bl = true;
        }
        if (n3 == 0) {
            bl2 = true;
        }
        if (!bl2 && n3 > n) {
            throw new IllegalArgumentException(rbh.getText("page_end_cannot_greater_than_num_pages"));
        }
        if (!bl && !bl2 && n2 > n3) {
            throw new IllegalArgumentException(rbh.getText("page_start_cannot_greater_than_page_end"));
        }
        if (!bl && n2 > n) {
            throw new IllegalArgumentException(rbh.getText("page_start_cannot_greater_than_num_pages"));
        }
    }

    private void validateRestartPrinting() {
        if (this.restartPrinting != -1 && this.restartPrinting != -2 && this.restartPrinting != -3) {
            int n = this.getTotalPages();
            int n2 = this.getPageRangeStart();
            int n3 = this.getPageRangeEnd();
            int n4 = this.getRestartPrinting();
            if (n4 < n2) {
                throw new IllegalArgumentException(rbh.getText("page_restart_cannot_less_than_page_start"));
            }
            if (n3 != 0) {
                if (n4 > n3) {
                    throw new IllegalArgumentException(rbh.getText("page_start_cannot_greater_than_page_end"));
                }
            } else if (n4 > n) {
                throw new IllegalArgumentException(rbh.getText("page_restart_cannot_greater_than_num_pages"));
            }
        }
    }

    public static String[] getStatusDescriptions() {
        return new String[]{"*CLOSED", "*DEFERRED", "*HELD", "*MESSAGE", "*OPEN", "*PENDING", "*PRINTER", "*READY", "*SAVED", "*SENDING", "*WRITING"};
    }

    public static Serializable[] getStatusValues() {
        return new Serializable[]{"*CLOSED", "*DEFERRED", "*HELD", "*MESSAGE", "*OPEN", "*PENDING", "*PRINTER", "*READY", "*SAVED", "*SENDING", "*WRITING"};
    }
}

