/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ValidationHelper;

public class OS400ProductLicense
extends CommonVersionedObject {
    private static final long serialVersionUID = -6270377773550172275L;
    public static final int TYPE_INVALID = 0;
    public static final int TYPE_PERMANENT = 1;
    public static final int TYPE_TEMPORARY = 2;
    public static final String PROCESSORTYPE_SYSTEM = "1";
    public static final String PROCESSORTYPE_LOCAL = "2";
    public static final String PROCESSORTYPE_LOCAL_REAL = "3";
    private String productCode = "";
    private String licenseCode = "";
    private String message = "";
    private String countMessage = "";
    private int codeType = 0;
    private int licenseCount = 0;
    private int daysToExpire = 0;
    private String expirationDate = "";
    private boolean useLicenseCount = false;
    private int processorLimit = 0;
    private String processorType = "";
    private int daysOverPrcLimit = 0;
    private int lastDateOverPrcLimit = 0;
    private boolean systemSpecificTempCode = false;

    public OS400ProductLicense() {
    }

    public OS400ProductLicense(String string) {
        this.productCode = string;
    }

    public void setProductCode(String string) {
        ValidationHelper.checkForNull((String)"Product Code", (Object)string);
        this.productCode = string;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setLicenseCode(String string) {
        this.licenseCode = string.trim().replaceAll("O", "+");
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setExpirationDate(String string) {
        this.expirationDate = string;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setDaysToExpire(int n) {
        this.daysToExpire = n;
    }

    public int getDaysToExpire() {
        return this.daysToExpire;
    }

    public void setUseLicenseCount(boolean bl) {
        this.useLicenseCount = bl;
    }

    public boolean useLicenseCount() {
        return this.useLicenseCount;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCountMessage(String string) {
        this.countMessage = string;
    }

    public String getCountMessage() {
        return this.countMessage;
    }

    public void setCodeType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid license code type: " + n);
        }
        this.codeType = n;
    }

    public int getCodeType() {
        return this.codeType;
    }

    public void setLicenseCount(int n) {
        this.licenseCount = n;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public int getProcessorLimit() {
        return this.processorLimit;
    }

    public void setProcessorLimit(int n) {
        this.processorLimit = n;
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public void setProcessorType(String string) {
        ValidationHelper.checkForNull((String)"Processor Type", (Object)string);
        String string2 = string.trim();
        if (!(string2.length() <= 0 || string2.equals(PROCESSORTYPE_LOCAL) || string2.equals(PROCESSORTYPE_LOCAL_REAL) || string2.equals(PROCESSORTYPE_SYSTEM))) {
            throw new IllegalArgumentException("Invalid processor type: " + string2);
        }
        this.processorType = string2;
    }

    public int getDaysOverPrcLimit() {
        return this.daysOverPrcLimit;
    }

    public void setDaysOverPrcLimit(int n) {
        this.daysOverPrcLimit = n;
    }

    public int getLastDateOverPrcLimit() {
        return this.lastDateOverPrcLimit;
    }

    public void setLastDateOverPrcLimit(int n) {
        this.lastDateOverPrcLimit = n;
    }

    public void setSystemSpecificTempCode(boolean bl) {
        this.systemSpecificTempCode = bl;
    }

    public boolean isSystemSpecificTempCode() {
        return this.systemSpecificTempCode;
    }

    public boolean getSystemSpecificTempCode() {
        return this.isSystemSpecificTempCode();
    }
}

