/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.IMessage;
import com.helpsystems.common.core.busobj.Proxy;
import java.util.Date;

public class OS400Message
extends Proxy
implements IMessage {
    private static final long serialVersionUID = 2071201306388047730L;
    public static final int COMPLETION = 1;
    public static final int DIAGNOSTIC = 2;
    public static final int INFORMATIONAL = 4;
    public static final int INQUIRY = 5;
    public static final int SENDERS_COPY = 6;
    public static final int REQUEST = 8;
    public static final int REQUEST_WITH_PROMPTING = 10;
    public static final int NOTIFY = 14;
    public static final int ESCAPE = 15;
    public static final int NOTIFY_NOT_HANDLED = 16;
    public static final int ESCAPE_NOT_HANDLED = 17;
    public static final int REPLY_NOT_VALIDITY_CHECKED = 21;
    public static final int REPLY_VALIDITY_CHECKED = 22;
    public static final int REPLY_MESSAGE_DEFAULT_USED = 23;
    public static final int REPLY_SYSTEM_DEFAULT_USED = 24;
    public static final int REPLY_FROM_SYSTEM_REPLY_LIST = 25;
    public static final int SEVERITY_INFORMATION = 0;
    public static final int SEVERITY_WARNING = 10;
    public static final int SEVERITY_ERROR = 20;
    public static final int SEVERITY_SEVERE_ERROR = 30;
    public static final int SEVERITY_ABNORMAL_END_OF_PROGRAM = 40;
    public static final int SEVERITY_ABNORMAL_END_OF_JOB = 50;
    public static final int SEVERITY_SYSTEM_STATUS = 60;
    public static final int SEVERITY_DEVICE_INTEGRITY = 70;
    public static final int SEVERITY_SYSTEM_ALERT = 80;
    public static final int SEVERITY_SYSTEM_INTEGRITY = 90;
    public static final int SEVERITY_ACTION = 99;
    public static String[] SEVERITIES = new String[]{String.valueOf(0), String.valueOf(10), String.valueOf(20), String.valueOf(30), String.valueOf(40), String.valueOf(50), String.valueOf(60), String.valueOf(70), String.valueOf(80), String.valueOf(90), String.valueOf(99)};
    private String messageId;
    private String messageFileName;
    private String messageFileLibrary;
    private String defaultReply;
    private String firstLevelText;
    private String secondLevelText;
    private int type = -1;
    private int severity = -1;
    private byte[] messageData;
    private String system;
    private String messageQueue;
    private String messageQueueLibrary;
    private Date messageDate;
    private String sendingProgram = "";
    private String sendingJobName = "";
    private String sendingUser = "";
    private String sendingJobNumber = "";
    private String currentUser = "";
    private byte[] messageKey;
    private String alertOption = "";
    private String replyStatus = "";

    public String getDefaultReply() {
        return this.defaultReply;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getLibraryName() {
        return this.messageFileLibrary;
    }

    public int getSeverity() {
        return this.severity;
    }

    public byte[] getMessageData() {
        return this.messageData;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        String string = "";
        switch (this.getType()) {
            case 1: {
                string = "Completion";
                break;
            }
            case 2: {
                string = "Diagnostic";
                break;
            }
            case 4: {
                string = "Informational";
                break;
            }
            case 5: {
                string = "Inquiry";
                break;
            }
            case 6: {
                string = "Senders copy";
                break;
            }
            case 8: {
                string = "Request";
                break;
            }
            case 10: {
                string = "Request with prompting";
                break;
            }
            case 14: {
                string = "Notify";
                break;
            }
            case 15: {
                string = "Escape";
                break;
            }
            case 16: {
                string = "Notify not handled";
                break;
            }
            case 17: {
                string = "Escape not handled";
                break;
            }
            case 21: {
                string = "Reply not validity checked";
                break;
            }
            case 22: {
                string = "Reply validity checked";
                break;
            }
            case 23: {
                string = "Reply message default used";
                break;
            }
            case 24: {
                string = "Reply system default used";
                break;
            }
            case 25: {
                string = "Reply from system reply list";
            }
        }
        return string;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public String getMessageFileName() {
        return this.messageFileName;
    }

    public String getFirstLevelText() {
        return this.firstLevelText;
    }

    public String getSendingJobNumber() {
        return this.sendingJobNumber;
    }

    public String getSendingProgram() {
        return this.sendingProgram;
    }

    public String getSendingJobName() {
        return this.sendingJobName;
    }

    public String getSendingUser() {
        return this.sendingUser;
    }

    public Date getMessageDate() {
        return this.messageDate;
    }

    public String getReplyStatus() {
        return this.replyStatus;
    }

    public String getSystem() {
        return this.system;
    }

    public byte[] getMessageKey() {
        return this.messageKey;
    }

    public String getMessageQueueLibrary() {
        return this.messageQueueLibrary;
    }

    public String getSecondLevelText() {
        return this.secondLevelText;
    }

    public String getMessageQueue() {
        return this.messageQueue;
    }

    public String getAlertOption() {
        return this.alertOption;
    }

    public String getName() {
        return this.messageId;
    }

    public String getDescription() {
        return this.messageFileLibrary + '/' + this.messageFileName;
    }

    public void setDefaultReply(String string) {
        this.defaultReply = string;
    }

    public void setMessageFileLibrary(String string) {
        this.messageFileLibrary = string;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public void setMessageData(byte[] byArray) {
        this.messageData = byArray;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setCurrentUser(String string) {
        this.currentUser = string;
    }

    public void setMessageFileName(String string) {
        this.messageFileName = string;
    }

    public void setFirstLevelText(String string) {
        this.firstLevelText = string;
    }

    public void setSendingJobNumber(String string) {
        this.sendingJobNumber = string;
    }

    public void setSendingProgram(String string) {
        this.sendingProgram = string;
    }

    public void setSendingJobName(String string) {
        this.sendingJobName = string;
    }

    public void setSendingUser(String string) {
        this.sendingUser = string;
    }

    public void setMessageDate(Date date) {
        this.messageDate = date;
    }

    public void setReplyStatus(String string) {
        this.replyStatus = string;
    }

    public void setSystem(String string) {
        this.system = string;
    }

    public void setMessageKey(byte[] byArray) {
        this.messageKey = byArray;
    }

    public void setMessageQueueLibrary(String string) {
        this.messageQueueLibrary = string;
    }

    public void setSecondLevelText(String string) {
        this.secondLevelText = string;
    }

    public void setMessageQueue(String string) {
        this.messageQueue = string;
    }

    public void setMessageId(String string) {
        this.messageId = string;
    }

    public void setAlertOption(String string) {
        this.alertOption = string;
    }
}

