/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.Proxy;

public class ASPListFilter
extends Proxy {
    private static final long serialVersionUID = 1821690444159155268L;
    public static final int ASP_ALL = -1;
    public static final int ASP_ALL_USER = -2;
    public static final int ASP_ALL_IASP = -3;
    public static final int MIN = 1;
    public static final int MAX = 255;
    private int aspNumber;
    public static final String ASP_INVALID = "The ASP number is not supported.  The valid range is 1 to 255.";

    public int getAspNumber() {
        return this.aspNumber;
    }

    public int getAspKey() {
        return 1;
    }

    public void setAspNumber(int n) {
        if (n != -1 && n != -2 && n != -3 && n < 1 && n > 255) {
            throw new IllegalArgumentException(ASP_INVALID);
        }
        this.aspNumber = n;
    }

    public boolean isValid() {
        return this.aspNumber == -1 || this.aspNumber == -2 || this.aspNumber == -3 || this.aspNumber >= 1 || this.aspNumber <= 255;
    }

    public String getAspString() {
        return Integer.toString(this.getAspNumber());
    }

    public String getName() {
        return this.getAspString();
    }
}

