/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.Proxy;

public class ASP
extends Proxy {
    private static final long serialVersionUID = -5462058563060001936L;
    public static final String SYSBASE = "*SYSBAS";
    public static final int UNAVAILABLE = -2;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_USERDEFINED = 1;
    public static final int USAGE_PRIMARY = 2;
    public static final int USAGE_SECONDARY = 3;
    public static final int STATUS_NOSTATUS = 0;
    public static final int STATUS_VARYOFF = 1;
    public static final int STATUS_VARYON = 2;
    public static final int STATUS_ACTIVE = 3;
    public static final int STATUS_AVAILABLE = 4;
    private int aspNumber;
    private String aspGroup;
    private String aspDevice;
    private int aspUsage = 0;
    private int aspStatus = 0;
    private int totalSize;
    private int totalFree;
    private int unprotectedTotal;
    private int unprotectedFree;
    private int protectedTotal;
    private int protectedFree;
    public static final String TOTAL_SIZE_MISSING = "The ASP Total Size was not available.  ";
    public static final String TOTAL_FREE_MISSING = "The ASP Total Free was not available.  ";
    public static final String UNPROT_SIZE_MISSING = "The Unprotected ASP Total Size was not available.  ";
    public static final String UNPROT_FREE_MISSING = "The Unprotected ASP Total Free was not available.  ";
    public static final String PROT_SIZE_MISSING = "The Protected ASP Total Size was not available.  ";
    public static final String PROT_FREE_MISSING = "The Protected ASP Total Free was not available.  ";
    public static final String TOOBIG = "The value returned was too large.";

    public String getAspName() {
        return ASP.getAspName(this.aspNumber);
    }

    public String getName() {
        String string = super.getName();
        if (string == null || string.length() == 0) {
            return this.getAspName();
        }
        return string;
    }

    public String getDescription() {
        return this.getAspGroup();
    }

    public int getAspNumber() {
        return this.aspNumber;
    }

    public void setAspNumber(int n) {
        if (n < 33 && n > 0) {
            this.setAspGroup(SYSBASE);
        }
        this.aspNumber = n;
    }

    public static String getAspName(int n) {
        String string = null;
        if (n < 1 || n > 255) {
            throw new IllegalArgumentException("The ASP number " + n + " must be a number between 1 and 255.");
        }
        string = new Integer(n).toString();
        if (string.length() > 2) {
            return string;
        }
        String string2 = "00";
        if (string.length() == 2) {
            string2 = "0";
        }
        string = string2 + string;
        return string;
    }

    public String getAspDevice() {
        return this.aspDevice;
    }

    public void setAspDevice(String string) {
        this.aspDevice = string;
    }

    public String getAspGroup() {
        return this.aspGroup;
    }

    public void setAspGroup(String string) {
        if (this.getAspNumber() < 33 && this.getAspNumber() > 0) {
            this.aspGroup = SYSBASE;
            return;
        }
        this.aspGroup = string == null || string.length() == 0 ? "Unknown" : string;
    }

    public int getTotalSize() throws ResourceUnavailableException {
        if (this.totalSize == -2) {
            throw new ResourceUnavailableException("The ASP Total Size was not available.  The value returned was too large.", null);
        }
        if (this.totalSize < 1) {
            throw new ResourceUnavailableException(TOTAL_SIZE_MISSING, null);
        }
        return this.totalSize;
    }

    public void setTotalSize(int n) {
        this.totalSize = n;
    }

    public int getTotalFree() throws ResourceUnavailableException {
        if (this.totalFree == -2) {
            throw new ResourceUnavailableException("The ASP Total Free was not available.  The value returned was too large.", null);
        }
        if (this.totalFree < 1) {
            throw new ResourceUnavailableException(TOTAL_FREE_MISSING, null);
        }
        return this.totalFree;
    }

    public void setTotalFree(int n) {
        this.totalFree = n;
    }

    public int getTotalUsed() throws ResourceUnavailableException {
        int n = 0;
        n = this.getTotalSize() - this.getTotalFree();
        return n;
    }

    public int getUnprotectedTotal() throws ResourceUnavailableException {
        if (this.unprotectedTotal == -2) {
            throw new ResourceUnavailableException("The Unprotected ASP Total Size was not available.  The value returned was too large.", null);
        }
        return this.unprotectedTotal;
    }

    public void setUnprotectedTotal(int n) {
        this.unprotectedTotal = n;
    }

    public int getUnprotectedFree() throws ResourceUnavailableException {
        if (this.unprotectedTotal == -2) {
            throw new ResourceUnavailableException("The Unprotected ASP Total Free was not available.  The value returned was too large.", null);
        }
        return this.unprotectedFree;
    }

    public void setUnprotectedFree(int n) {
        this.unprotectedFree = n;
    }

    public int getUnprotectedUsed() throws ResourceUnavailableException {
        int n = 0;
        n = this.getUnprotectedTotal() - this.getUnprotectedFree();
        return n;
    }

    public int getProtectedTotal() throws ResourceUnavailableException {
        if (this.protectedTotal == -2) {
            throw new ResourceUnavailableException("The Protected ASP Total Size was not available.  The value returned was too large.", null);
        }
        return this.protectedTotal;
    }

    public void setProtectedTotal(int n) {
        this.protectedTotal = n;
    }

    public int getProtectedFree() throws ResourceUnavailableException {
        if (this.protectedFree == -2) {
            throw new ResourceUnavailableException("The Protected ASP Total Free was not available.  The value returned was too large.", null);
        }
        return this.protectedFree;
    }

    public void setProtectedFree(int n) {
        this.protectedFree = n;
    }

    public int getProtectedUsed() throws ResourceUnavailableException {
        int n = 0;
        n = this.getProtectedTotal() - this.getProtectedFree();
        return n;
    }

    public int getAspUsage() {
        return this.aspUsage;
    }

    public void setAspUsage(int n) {
        this.aspUsage = n;
    }

    public int getAspStatus() {
        return this.aspStatus;
    }

    public void setAspStatus(int n) {
        this.aspStatus = n;
    }

    public boolean equals(Object object) {
        if (object instanceof ASP) {
            return this.getAspNumber() == ((ASP)((Object)object)).getAspNumber();
        }
        return false;
    }

    public String toString() {
        return this.getAspName().trim() + " " + this.getAspGroup().trim();
    }
}

