/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.dm.RelModDM;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharacterDataArea;
import com.ibm.as400.access.ObjectDoesNotExistException;

public class RelModDMAS400
extends AbstractAS400Manager
implements RelModDM {
    private String library;
    private String productDataArea;
    private String interfaceDataArea;

    public RelModDMAS400(String string, String string2, String string3, String string4, String string5) {
        super(string2);
        this.setName(string5);
        ValidationHelper.checkForNullAndBlank((String)"Library", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"Product Data Area Name", (String)string3);
        ValidationHelper.checkForNullAndBlank((String)"Interface Data Area Name", (String)string4);
        this.productDataArea = string3;
        this.interfaceDataArea = string4;
        this.library = string;
    }

    public RelMod retrieveProductVersion() throws NoDataException, ResourceUnavailableException {
        return this.fetchRelMod(this.library, this.productDataArea);
    }

    public RelMod retrieveInterfaceVersion() throws NoDataException, ResourceUnavailableException {
        return this.fetchRelMod(this.library, this.interfaceDataArea);
    }

    private RelMod fetchRelMod(String string, String string2) throws NoDataException, ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            RelMod relMod;
            wrappedAS400 = this.borrowConnection();
            CharacterDataArea characterDataArea = new CharacterDataArea((AS400)wrappedAS400, "/QSYS.lib/" + string + ".lib/" + string2 + ".dtaara");
            String string3 = characterDataArea.read();
            RelMod relMod2 = relMod = RelMod.parse((String)string3);
            return relMod2;
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            throw new NoDataException("Unable to find Release/Modification data area.", (Throwable)objectDoesNotExistException);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve the version from " + string + "/" + string2, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    public RelMod retrieveVersion(String string, String string2) throws NoDataException, ResourceUnavailableException {
        ValidationHelper.checkForNullAndBlank((String)"Library Name", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"Data Area Name", (String)string2);
        return this.fetchRelMod(string, string2);
    }
}

