/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.ProgramCallDocument;
import org.apache.log4j.Logger;

public abstract class PCMLUtil {
    static Logger logger = Logger.getLogger(PCMLUtil.class);
    protected static ProgramCallDocument pcmlGenerateToken;
    protected static ProgramCallDocument pcmlSetToken;
    protected static ProgramCallDocument pcmlWhoami;
    protected static ProgramCallDocument pcmlRTVNETA;
    public static String WHOAMI_PROGRAM;

    public static byte[] generateToken(AS400 aS400, String string, String string2) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Password", (Object)string2);
        return PCMLUtil.generateToken(aS400, string, string2.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] generateToken(AS400 aS400, String string, char[] cArray) throws ResourceUnavailableException {
        char[] cArray2 = cArray;
        if (aS400 == null) {
            throw new NullPointerException("The AS400 object passed in was null.");
        }
        if (string == null) {
            throw new NullPointerException("The username passed in was null.");
        }
        if (cArray2 == null || cArray2.length == 0) {
            cArray2 = "*NOPWD".toCharArray();
        }
        try {
            ProgramCallDocument programCallDocument = null;
            ProgramCallDocument programCallDocument2 = pcmlGenerateToken;
            synchronized (programCallDocument2) {
                programCallDocument = pcmlGenerateToken;
                programCallDocument.setSystem(aS400);
                programCallDocument.setValue("QSYGENPT.Username", (Object)string);
                programCallDocument.setValue("QSYGENPT.Password", (Object)new String(cArray2));
                programCallDocument.setValue("QSYGENPT.Timeout", (Object)new Integer(60));
                programCallDocument.setValue("QSYGENPT.TokenType", (Object)"2");
                programCallDocument.setValue("QSYGENPT.err", (Object)new String(new char[500]));
                programCallDocument.setValue("QSYGENPT.PasswordLength", (Object)new Integer(cArray2.length));
                byte[] byArray = (byte[])AbstractProgramCallManager.doCallAndReturn(programCallDocument, "QSYGENPT", "ProfileToken");
                return byArray;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("An error occurred when invoking QSYGENPT to generate a  Token for " + string + " on server " + aS400.getSystemName(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean swap(AS400 aS400, byte[] byArray) throws ResourceUnavailableException {
        if (aS400 == null) {
            throw new NullPointerException("The AS400 object passed in was null.");
        }
        if (byArray == null) {
            throw new NullPointerException("The token passed in was null.");
        }
        try {
            ProgramCallDocument programCallDocument = null;
            ProgramCallDocument programCallDocument2 = pcmlSetToken;
            synchronized (programCallDocument2) {
                programCallDocument = pcmlSetToken;
                programCallDocument.setSystem(aS400);
                programCallDocument.setValue("QSYSETPT.ProfileToken", (Object)byArray);
                programCallDocument.setValue("QSYSETPT.err", (Object)new String(new char[500]));
                AbstractProgramCallManager.doCallAndReturn(programCallDocument, "QSYSETPT", null);
                return true;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("An error occurred when invoking QSYSETPT to swap to a different user on server " + aS400.getSystemName(), (Throwable)exception);
        }
    }

    public static String whoami(AS400 aS400) throws ResourceUnavailableException {
        return PCMLUtil.whoami(aS400, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String whoami(AS400 aS400, String string) throws ResourceUnavailableException {
        if (aS400 == null) {
            throw new NullPointerException("The AS400 object passed in was null.");
        }
        String string2 = string;
        if (string == null) {
            if (aS400 instanceof WrappedAS400) {
                string2 = ((WrappedAS400)aS400).getSysLibrary();
            }
            if (string2 == null) {
                string2 = "RBTSYSLIB";
            }
        }
        try {
            ProgramCallDocument programCallDocument = null;
            ProgramCallDocument programCallDocument2 = pcmlWhoami;
            synchronized (programCallDocument2) {
                programCallDocument = pcmlWhoami;
                programCallDocument.setSystem(aS400);
                programCallDocument.setPath("whoami", "/QSYS.lib/" + string2 + ".lib/" + WHOAMI_PROGRAM + ".pgm");
                String string3 = (String)AbstractProgramCallManager.doCallAndReturn(programCallDocument, "whoami", "Username");
                return string3;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("An error occurred while executing " + string2 + "." + WHOAMI_PROGRAM + " on " + aS400.getSystemName(), (Throwable)exception);
        }
    }

    static {
        WHOAMI_PROGRAM = "RSL841";
        try {
            pcmlGenerateToken = new ProgramCallDocument(null, "com.helpsystems.common.as400.access.common");
            pcmlSetToken = new ProgramCallDocument(null, "com.helpsystems.common.as400.access.common");
            pcmlWhoami = new ProgramCallDocument(null, "com.helpsystems.common.as400.access.common");
            pcmlRTVNETA = new ProgramCallDocument(null, "com.helpsystems.common.as400.access.common");
        }
        catch (Exception exception) {
            logger.debug((Object)"Error when creating PCML docs.", (Throwable)exception);
        }
    }
}

