/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400Job;
import com.helpsystems.common.as400.busobj.OS400MessageSendInfo;
import com.helpsystems.common.as400.dataset.JobLogSource;
import com.helpsystems.common.as400.dataset.MessageDataSet;
import com.helpsystems.common.as400.dataset.MessageQueueSource;
import com.helpsystems.common.as400.dataset.QHSTDataSet;
import com.helpsystems.common.as400.dm.OS400MessageDM;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.JobLog;
import com.ibm.as400.access.MessageQueue;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import java.util.Date;
import org.apache.log4j.Logger;

public class OS400MessageDMAS400
extends AbstractProgramCallManager
implements OS400MessageDM {
    private static final String PCML_FILE = "com.helpsystems.common.as400.access.OS400MessageDMAS400";
    private static final String QHST_PROGRAM_NAME = "RSL3041";
    private static final String QSYS_LIBRARY_NAME = "QSYS";
    private static final String QMHSNDM = "QMHSNDM";
    private static final String LIBL = "*LIBL";
    private String library = "*LIBL";
    private static final Logger logger = Logger.getLogger(OS400MessageDMAS400.class);

    public OS400MessageDMAS400(String string, String string2, String string3) throws PcmlException {
        super(PCML_FILE, string, string2, null);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string3);
        this.setName(string3);
    }

    @Override
    public DataSet getFromJobLog(UserIdentity userIdentity, String string, String string2, String string3) throws ResourceUnavailableException, DataException {
        if (string == null) {
            throw new NullPointerException("The job name passed in is null.");
        }
        String string4 = string.trim();
        if (string2 == null) {
            throw new NullPointerException("The job user passed in is null.");
        }
        String string5 = string2.trim();
        if (string3 == null) {
            throw new NullPointerException("The job number passed in is null.");
        }
        String string6 = string3.trim();
        WrappedAS400 wrappedAS400 = null;
        DataSet dataSet = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            JobLog jobLog = new JobLog((AS400)wrappedAS400, string4, string5, string6);
            logger.trace((Object)("Retrieving messages from joblog for job " + string6 + "/" + string5 + "/" + string4));
            dataSet = MessageDataSet.createDataSet(new JobLogSource(jobLog));
        }
        catch (Exception exception) {
            try {
                wrappedAS400.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string7 = exception.getCause().getMessage();
            if (string7.indexOf("CPF2443") > -1 || string7.indexOf("CPF3C53") > -1) {
                throw new NoDataException(string7);
            }
            throw new ResourceUnavailableException(string7, (Throwable)exception);
        }
        return dataSet;
    }

    @Override
    public DataSet getFromJobLog(UserIdentity userIdentity, OS400Job oS400Job) throws ResourceUnavailableException, DataException {
        String string = oS400Job.getJobName();
        String string2 = oS400Job.getCurrentUser();
        String string3 = oS400Job.getJobNumber();
        return this.getFromJobLog(userIdentity, string, string2, string3);
    }

    @Override
    public DataSet getQHST(UserIdentity userIdentity, OS400Job oS400Job) throws ResourceUnavailableException {
        String string = oS400Job.getJobName();
        String string2 = oS400Job.getCurrentUser();
        String string3 = oS400Job.getJobNumber();
        return this.getQHST(userIdentity, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet getQHST(UserIdentity userIdentity, String string, String string2, String string3) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            logger.trace((Object)("Building QHST index for job " + string3 + "/" + string2 + "/" + string + "."));
            int n = -1;
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem((AS400)wrappedAS400);
                String string4 = "/QSYS.LIB/" + this.library.trim() + ".LIB/" + QHST_PROGRAM_NAME + ".PGM";
                this.pcml.setPath(QHST_PROGRAM_NAME, string4);
                this.pcml.setIntValue("RSL3041.beginDate", 0);
                this.pcml.setIntValue("RSL3041.beginTime", 0);
                this.pcml.setIntValue("RSL3041.endDate", 0);
                this.pcml.setIntValue("RSL3041.endTime", 0);
                this.pcml.setValue("RSL3041.jobNumber", (Object)string3);
                this.pcml.setValue("RSL3041.jobUser", (Object)string2);
                this.pcml.setValue("RSL3041.jobName", (Object)string);
                this.pcml.setValue("RSL3041.curUser", (Object)" ");
                this.doCall(QHST_PROGRAM_NAME);
                n = this.pcml.getIntValue("RSL3041.numIndexed");
                logger.trace((Object)("Number of records indexed: " + n));
                return QHSTDataSet.createDataSet(wrappedAS400, this.pcml, n, this.library);
            }
        }
        catch (Exception exception) {
            try {
                wrappedAS400.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string5 = "Error retrieving QHST entries.";
            throw new ResourceUnavailableException(string5, (Throwable)exception);
        }
    }

    @Override
    public DataSet getQHST(UserIdentity userIdentity, Date date, Date date2) throws ResourceUnavailableException {
        return this.getQHST(userIdentity, date, date2, " ", " ", " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet getQHST(UserIdentity userIdentity, Date date, Date date2, String string, String string2, String string3) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            logger.trace((Object)("Building QHST index from " + date + " to " + date2));
            String string4 = DateTranslator.packDate((Date)date);
            String string5 = DateTranslator.packTime((Date)date);
            if (string5.length() < 4) {
                string5 = "0" + string5.trim();
            }
            string5 = string5 + "00";
            String string6 = DateTranslator.packDate((Date)date2);
            String string7 = DateTranslator.packTime((Date)date2);
            if (string7.length() < 4) {
                string7 = "0" + string7.trim();
            }
            string7 = string7 + "00";
            int n = -1;
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                this.pcml.setSystem((AS400)wrappedAS400);
                String string8 = "/QSYS.LIB/" + this.library.trim() + ".LIB/" + QHST_PROGRAM_NAME + ".PGM";
                this.pcml.setPath(QHST_PROGRAM_NAME, string8);
                this.pcml.setIntValue("RSL3041.beginDate", Integer.parseInt(string4));
                this.pcml.setIntValue("RSL3041.beginTime", Integer.parseInt(string5));
                this.pcml.setIntValue("RSL3041.endDate", Integer.parseInt(string6));
                this.pcml.setIntValue("RSL3041.endTime", Integer.parseInt(string7));
                this.pcml.setValue("RSL3041.jobNumber", (Object)string3);
                this.pcml.setValue("RSL3041.jobUser", (Object)string2);
                this.pcml.setValue("RSL3041.jobName", (Object)string);
                this.pcml.setValue("RSL3041.curUser", (Object)" ");
                this.doCall(QHST_PROGRAM_NAME);
                n = this.pcml.getIntValue("RSL3041.numIndexed");
                return QHSTDataSet.createDataSet(wrappedAS400, this.pcml, n, this.library);
            }
        }
        catch (Exception exception) {
            try {
                wrappedAS400.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            String string9 = "Error retrieving QHST entries.";
            throw new ResourceUnavailableException(string9, (Throwable)exception);
        }
    }

    @Override
    public DataSet getFromMessageQueue(UserIdentity userIdentity, String string, String string2) throws ResourceUnavailableException {
        return this.getFromMessageQueue(userIdentity, this.buildPath(string2, string));
    }

    @Override
    public DataSet getFromMessageQueue(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        DataSet dataSet = null;
        MessageQueue messageQueue = new MessageQueue((AS400)wrappedAS400, string);
        logger.trace((Object)("Retrieving messages from message queue: " + string));
        try {
            dataSet = MessageDataSet.createDataSet(new MessageQueueSource(messageQueue));
        }
        catch (Exception exception) {
            wrappedAS400.close();
            throw new ResourceUnavailableException("Error retrieving messages from message queue.", (Throwable)exception);
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOS400Message(OS400MessageSendInfo oS400MessageSendInfo, UserIdentity userIdentity) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                String string;
                this.pcml.setSystem((AS400)wrappedAS400);
                String string2 = "/QSYS.LIB/*LIBL.LIB/QMHSNDM.PGM";
                this.pcml.setPath(QMHSNDM, string2);
                String string3 = oS400MessageSendInfo.getMsgID();
                if (string3 != null && string3.length() > 0) {
                    this.pcml.setValue("QMHSNDM.msgID", (Object)string3);
                    this.pcml.setValue("QMHSNDM.msgFile.object", (Object)oS400MessageSendInfo.getMsgFile());
                    this.pcml.setValue("QMHSNDM.msgFile.library", (Object)oS400MessageSendInfo.getMsgFileLib());
                } else {
                    this.pcml.setValue("QMHSNDM.msgID", (Object)"");
                    this.pcml.setValue("QMHSNDM.msgFile.object", (Object)"");
                    this.pcml.setValue("QMHSNDM.msgFile.library", (Object)"");
                    if (oS400MessageSendInfo.getMsgData().length() == 0) {
                        throw new RuntimeException("Impromptu message text is required.");
                    }
                }
                String string4 = oS400MessageSendInfo.getMsgData();
                this.pcml.setValue("QMHSNDM.msgData", (Object)string4);
                this.pcml.setIntValue("QMHSNDM.msgDataLen", string4.length());
                String string5 = null;
                String string6 = "";
                String string7 = "";
                switch (oS400MessageSendInfo.getMsgType()) {
                    case 1: {
                        string5 = "*COMP";
                        break;
                    }
                    case 2: {
                        string5 = "*DIAG";
                        break;
                    }
                    case 4: {
                        string5 = "*INQ";
                        string6 = "*PGMQ";
                        break;
                    }
                    default: {
                        string5 = "*INFO";
                    }
                }
                this.pcml.setValue("QMHSNDM.msgType", (Object)string5);
                int[] nArray = new int[]{0};
                if (oS400MessageSendInfo.isSendToQSYSOPR()) {
                    this.pcml.setValue("QMHSNDM.msgQueues.object", nArray, (Object)"*SYSOPR");
                    this.pcml.setValue("QMHSNDM.msgQueues.library", nArray, (Object)"");
                    nArray[0] = nArray[0] + 1;
                } else if (oS400MessageSendInfo.isSendToHistoryLog()) {
                    this.pcml.setValue("QMHSNDM.msgQueues.object", nArray, (Object)"*HSTLOG");
                    this.pcml.setValue("QMHSNDM.msgQueues.library", nArray, (Object)"");
                    nArray[0] = nArray[0] + 1;
                }
                String string8 = oS400MessageSendInfo.getSendToUser();
                if (string8 != null && string8.length() > 0) {
                    this.pcml.setValue("QMHSNDM.msgQueues.object", nArray, (Object)string8);
                    this.pcml.setValue("QMHSNDM.msgQueues.library", nArray, (Object)"*USER");
                    nArray[0] = nArray[0] + 1;
                }
                if ((string = oS400MessageSendInfo.getSendToMsgQueue()) != null && string.length() > 0) {
                    this.pcml.setValue("QMHSNDM.msgQueues.object", nArray, (Object)string);
                    this.pcml.setValue("QMHSNDM.msgQueues.library", nArray, (Object)oS400MessageSendInfo.getSendToMsgQueueLib());
                    nArray[0] = nArray[0] + 1;
                }
                if (nArray[0] == 0) {
                    throw new RuntimeException("No specified message destinations: history log, qsysopr, user, or message queue");
                }
                this.pcml.setIntValue("QMHSNDM.msgQCount", nArray[0]);
                this.pcml.setValue("QMHSNDM.replyQueue.object", (Object)string6);
                this.pcml.setValue("QMHSNDM.replyQueue.library", (Object)string7);
                this.doCall(QMHSNDM);
            }
        }
        catch (Exception exception) {
            String string = "Error sending OS400 Message.";
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
        finally {
            super.releaseConnection(wrappedAS400);
        }
    }

    private String buildPath(String string, String string2) {
        String string3 = "";
        string3 = string.equals(QSYS_LIBRARY_NAME) ? "/" + string.toUpperCase().trim() + ".LIB/" + string2 + ".MSGQ" : "/QSYS.LIB/" + string.toUpperCase().trim() + ".LIB/" + string2.toUpperCase().trim() + ".MSGQ";
        return string3;
    }
}

