/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.QUSRJOBI_Job;
import com.helpsystems.common.as400.dm.OS400CommandInfoDM;
import com.helpsystems.common.as400.ex.CommandCallException;
import com.helpsystems.common.as400.ex.CommandCallSecurityException;
import com.helpsystems.common.as400.ex.CommandExecutionMessage;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.as400.util.QUSRJOBI_API;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.data.PcmlException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OS400CommandInfoPCML
extends AbstractProgramCallManager
implements OS400CommandInfoDM {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400CommandInfoPCML.class);
    private static final Logger logger = Logger.getLogger(OS400CommandInfoPCML.class);
    private static final String END_XML = "</QcdCLCmd>";
    private static final byte[] LOWER_CODE_PAGE = new byte[256];

    public OS400CommandInfoPCML(String string) throws PcmlException {
        super("com.helpsystems.common.as400.access.commandprompter", string);
        this.setName("COMMON.OS400CommandInfoDM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCommandInfo(UserIdentity userIdentity, String string, String string2, String string3) throws ResourceUnavailableException {
        String string4;
        Object object;
        Object object2;
        String string5 = null;
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        QUSRJOBI_Job qUSRJOBI_Job = null;
        if (string != null) {
            object2 = new QUSRJOBI_API(wrappedAS400);
            qUSRJOBI_Job = ((QUSRJOBI_API)object2).runAPI();
            object = new CommandCall((AS400)wrappedAS400);
            string4 = "SETASPGRP ASPGRP(" + string + ")";
            try {
                OS400CommandInfoPCML.runCommand(string4, (CommandCall)object);
            }
            catch (Exception exception) {
                this.releaseConnection(wrappedAS400);
                throw new ResourceUnavailableException("Unable to switch to ASP group " + string, (Throwable)exception);
            }
        }
        try {
            object2 = this.pcml;
            synchronized (object2) {
                this.pcml.setSystem((AS400)wrappedAS400);
                this.pcml.setPath("QCDRCMDD", "/QSYS.lib/QCDRCMDD.pgm");
                this.pcml.setValue("QCDRCMDD.Command.Name", (Object)string2.toUpperCase());
                this.pcml.setValue("QCDRCMDD.Command.Library", (Object)string3.toUpperCase());
                this.doCall("QCDRCMDD");
                object = (byte[])this.pcml.getValue("QCDRCMDD.Receiver.Data");
                string5 = new String((byte[])object, "UTF-8");
                string5 = string5.trim();
            }
        }
        catch (Exception exception) {
            this.releaseConnection(wrappedAS400);
            object = exception.getMessage();
            if (object != null && ((String)object).indexOf("CPF9801") > -1) {
                throw new ResourceUnavailableException("The command " + string3 + "/" + string2 + " was not found.", (Throwable)exception);
            }
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to retrieve command info: " + string3 + "/" + string2, (Throwable)exception);
        }
        if (qUSRJOBI_Job != null) {
            object2 = "SETASPGRP ASPGRP(" + qUSRJOBI_Job.getAspGroup() + ")";
            object = new CommandCall((AS400)wrappedAS400);
            try {
                OS400CommandInfoPCML.runCommand((String)object2, (CommandCall)object);
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to switch back to ASP " + qUSRJOBI_Job.getAspGroup()));
                wrappedAS400.disconnectAllServices();
            }
        }
        if (string5.endsWith(END_XML)) {
            try {
                object2 = new StringBuffer(string5);
                ((StringBuffer)object2).delete(((StringBuffer)object2).length() - END_XML.length(), ((StringBuffer)object2).length());
                object = new SystemValue((AS400)wrappedAS400, "QDATFMT");
                string4 = (String)object.getValue();
                ((StringBuffer)object2).append("<Extra name=\"dateFormat\" value=\"" + string4 + "\"/>");
                object = new SystemValue((AS400)wrappedAS400, "QDATSEP");
                String string6 = (String)object.getValue();
                ((StringBuffer)object2).append("<Extra name=\"dateSeparator\" value=\"" + string6 + "\"/>");
                object = new SystemValue((AS400)wrappedAS400, "QTIMSEP");
                String string7 = (String)object.getValue();
                ((StringBuffer)object2).append("<Extra name=\"timeSeparator\" value=\"" + string7 + "\"/>");
                ((StringBuffer)object2).append(END_XML);
                string5 = ((StringBuffer)object2).toString();
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Unable to retrieve system data/time formatting info.", (Throwable)exception);
            }
        }
        this.releaseConnection(wrappedAS400);
        return string5;
    }

    @Override
    public Properties fetchMessages(UserIdentity userIdentity, String string, String string2, String[] stringArray) throws ResourceUnavailableException {
        CharSequence charSequence;
        ValidationHelper.checkForNull((String)"Key array", (Object)stringArray);
        Properties properties = new Properties();
        WrappedAS400 wrappedAS400 = this.borrowConnection(userIdentity);
        MessageFile messageFile = null;
        MessageFile messageFile2 = null;
        String string3 = "/QSYS.LIB/QCPFMSG.MSGF";
        try {
            messageFile = new MessageFile((AS400)wrappedAS400, string3);
            if (string2 != null) {
                charSequence = new StringBuffer("/QSYS.LIB/");
                if (string != null && !"QSYS".equalsIgnoreCase(string)) {
                    ((StringBuffer)charSequence).append(string.toUpperCase());
                    ((StringBuffer)charSequence).append(".LIB/");
                }
                ((StringBuffer)charSequence).append(string2.toUpperCase());
                ((StringBuffer)charSequence).append(".MSGF");
                string3 = ((StringBuffer)charSequence).toString();
                messageFile2 = new MessageFile((AS400)wrappedAS400, string3);
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to open Message File " + string3);
        }
        charSequence = null;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                charSequence = stringArray[i];
                String string4 = null;
                if (messageFile2 != null) {
                    try {
                        object = messageFile2.getMessage(stringArray[i]);
                        if (object != null) {
                            string4 = (String)charSequence + ": " + object.getText();
                        }
                    }
                    catch (ObjectDoesNotExistException objectDoesNotExistException) {
                    }
                    catch (AS400Exception aS400Exception) {
                        // empty catch block
                    }
                }
                if (string4 == null) {
                    try {
                        object = messageFile.getMessage(stringArray[i]);
                        if (object != null) {
                            string4 = (String)charSequence + ": " + object.getText();
                        }
                    }
                    catch (ObjectDoesNotExistException objectDoesNotExistException) {
                    }
                    catch (AS400Exception aS400Exception) {
                        // empty catch block
                    }
                }
                if (string4 == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Text not available for message ");
                    ((StringBuffer)object).append(stringArray[i]);
                    ((StringBuffer)object).append(" in QCPFMSG");
                    if (string2 != null && !string2.equalsIgnoreCase("QCPFMSG")) {
                        ((StringBuffer)object).append(" or ");
                        if (string != null) {
                            ((StringBuffer)object).append(string.toUpperCase());
                            ((StringBuffer)object).append("/");
                        }
                        ((StringBuffer)object).append(string2.toUpperCase());
                    }
                    string4 = ((StringBuffer)object).toString();
                }
                properties.setProperty(stringArray[i], string4);
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve message ID " + (String)charSequence, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        return properties;
    }

    @Override
    public char[] getCharMap() throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            String string = CharConverter.byteArrayToString((AS400)wrappedAS400, (byte[])LOWER_CODE_PAGE);
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            char[] cArray2 = cArray;
            return cArray2;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to get the character set from the server. ", (Throwable)exception);
        }
        finally {
            try {
                wrappedAS400.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String getCommandHelp(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        throw new ResourceUnavailableException("Not yet implemented.", null);
    }

    @Override
    public Object validateCommandString(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        CommandExecutionResponse commandExecutionResponse = null;
        WrappedAS400 wrappedAS400 = userIdentity != null ? this.borrowConnection(userIdentity) : this.borrowConnection();
        String string2 = string.replaceAll("'", "''");
        DecimalFormat decimalFormat = new DecimalFormat("##########");
        ((NumberFormat)decimalFormat).setMinimumIntegerDigits(10);
        int n = string.length();
        String string3 = "' x'" + decimalFormat.format(n) + "00000F')";
        String string4 = "call qcmdchk parm('" + string2 + string3;
        try {
            commandExecutionResponse = OS400CommandInfoPCML.runCommand(string4, wrappedAS400);
            if (!commandExecutionResponse.isSuccessful()) {
                CommandExecutionMessage[] commandExecutionMessageArray = commandExecutionResponse.getMessages();
                throw new ResourceUnavailableException(commandExecutionMessageArray[commandExecutionMessageArray.length - 1].getText());
            }
        }
        catch (CommandCallSecurityException commandCallSecurityException) {
            throw new ResourceUnavailableException(rbh.getMsg("user_not_authorized", (Object)string), (Throwable)commandCallSecurityException);
        }
        catch (CommandCallException commandCallException) {
            throw new ResourceUnavailableException("CommandCallException", (Throwable)commandCallException);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        return commandExecutionResponse;
    }

    @Override
    public String callPromptControl(String string, String string2, String string3, String string4, String string5) throws ResourceUnavailableException {
        String string6;
        ValidationHelper.checkForNullAndBlank((String)"Program name", (String)string2);
        String string7 = string2.toUpperCase();
        ValidationHelper.checkForNullAndBlank((String)"Command name", (String)string3);
        String string8 = string3.toUpperCase();
        ValidationHelper.checkForNullAndBlank((String)"Parameter name", (String)string4);
        String string9 = string4.toUpperCase();
        if (!string7.endsWith(".PGM")) {
            string7 = string7 + ".PGM";
        }
        if (!(string6 = string == null || string.length() == 0 ? "QSYS.LIB" : string.toUpperCase()).endsWith(".LIB")) {
            string6 = string6 + ".LIB";
        }
        String string10 = string5 == null ? "" : string5;
        String string11 = null;
        string11 = string6.startsWith("QSYS.LIB") ? "/" + string6 + "/" + string7 : "/QSYS.LIB/" + string6 + "/" + string7;
        String string12 = null;
        WrappedAS400 wrappedAS400 = this.borrowConnection();
        try {
            ProgramCall programCall = new ProgramCall((AS400)wrappedAS400);
            ProgramParameter[] programParameterArray = new ProgramParameter[3];
            byte[] byArray = new byte[20];
            AS400Text aS400Text = new AS400Text(10);
            byte[] byArray2 = aS400Text.toBytes((Object)string8);
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray2 = aS400Text.toBytes((Object)string9);
            System.arraycopy(byArray2, 0, byArray, 10, byArray2.length);
            programParameterArray[0] = new ProgramParameter(byArray);
            AS400Text aS400Text2 = new AS400Text(20);
            programParameterArray[1] = new ProgramParameter(aS400Text2.toBytes((Object)string10));
            programParameterArray[2] = new ProgramParameter(32);
            programCall.setProgram(string11, programParameterArray);
            AbstractAS400Manager.runProgram(programCall);
            AS400Text aS400Text3 = new AS400Text(32);
            string12 = (String)aS400Text3.toObject(programParameterArray[2].getOutputData());
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to call the prompt control program " + string11, (Throwable)exception);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        return string12;
    }

    static {
        for (int i = 0; i < LOWER_CODE_PAGE.length; ++i) {
            OS400CommandInfoPCML.LOWER_CODE_PAGE[i] = (byte)i;
        }
    }
}

