/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.LicensedProduct;
import com.helpsystems.common.as400.busobj.OS400ProductLicense;
import com.helpsystems.common.as400.dm.LicensedProductDM;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.ibm.as400.access.AS400;
import com.ibm.as400.data.PcmlException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LicensedProductDMAS400
extends AbstractProgramCallManager
implements LicensedProductDM {
    private static final Logger logger = Logger.getLogger(LicensedProductDMAS400.class);
    private static final String PCML_FILE = "com.helpsystems.common.as400.access.rsl8075";
    private static String library = "*LIBL";
    private static String pgm = "RSL8075";

    public LicensedProductDMAS400(String string) throws PcmlException {
        super(PCML_FILE, string);
        this.setName("COMMON.LicensedProductDM");
    }

    @Override
    public LicensedProduct[] getLicensedProducts() throws ResourceUnavailableException {
        LicensedProduct[] licensedProductArray = null;
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            licensedProductArray = this.getLicensedProducts(wrappedAS400);
        }
        finally {
            this.releaseConnection(wrappedAS400);
        }
        return licensedProductArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicensedProduct[] getLicensedProducts(AS400 aS400) throws ResourceUnavailableException {
        LicensedProduct[] licensedProductArray;
        ArrayList<LicensedProduct> arrayList = new ArrayList<LicensedProduct>();
        try {
            licensedProductArray = this.pcml;
            synchronized (this.pcml) {
                int n;
                this.pcml.setSystem(aS400);
                String string = "/QSYS.LIB/" + library.trim() + ".LIB/RSL8075.PGM";
                this.pcml.setPath(pgm, string);
                logger.trace((Object)("Getting license info with: " + string));
                this.pcml.setValue(pgm + ".hardwareInfo", (Object)" ");
                this.pcml.setValue(pgm + ".licenseInfo", (Object)" ");
                this.doCall(pgm);
                String string2 = (String)this.pcml.getValue(pgm + ".hardwareInfo");
                logger.debug((Object)("Hardware Info: " + string2));
                String string3 = (String)this.pcml.getValue(pgm + ".licenseInfo");
                logger.debug((Object)("License Info: " + string3));
                if (string3.length() != 5000) {
                    throw new ResourceUnavailableException("The license info data must be 5000 bytes. It is " + string3.length());
                }
                try {
                    n = Integer.parseInt(string3.substring(0, 3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ResourceUnavailableException("The product count is not valid.", (Throwable)numberFormatException);
                }
                if (n > 21) {
                    throw new ResourceUnavailableException("The product count exceeds 20: " + n);
                }
                int n2 = 3;
                int n3 = 230;
                for (int i = 0; i < n; ++i) {
                    int n4 = n2 + i * n3;
                    String string4 = string3.substring(n4, n4 + n3);
                    String string5 = string4.substring(0, 3).trim();
                    String string6 = string4.substring(3, 5).trim();
                    String string7 = string4.substring(5, 6).trim();
                    String string8 = string4.substring(6, 16).trim();
                    String string9 = string4.substring(16, 29).trim();
                    String string10 = string4.substring(29, 30).trim();
                    String string11 = string4.substring(30, 230);
                    if (string5.length() == 0) {
                        logger.debug((Object)("A product code was not returned for entry number: " + (i + 1)));
                        continue;
                    }
                    if (string6.length() != 0) {
                        logger.debug((Object)("Error " + string6 + " was reported while getting information for " + string5));
                        continue;
                    }
                    if (!string7.equals("1")) {
                        logger.debug((Object)(string5 + " is not installed."));
                        continue;
                    }
                    LicensedProduct licensedProduct = new LicensedProduct();
                    licensedProduct.setPrdCode(string5);
                    licensedProduct.setLibrary(string8);
                    licensedProduct.setRelMod(string9);
                    if (string10.equals("1")) {
                        String string12 = string11.substring(0, 1);
                        String string13 = string11.substring(1, 7);
                        int n5 = 0;
                        try {
                            n5 = Integer.parseInt(string11.substring(7, 13));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        String string14 = string11.substring(13, 68);
                        OS400ProductLicense oS400ProductLicense = new OS400ProductLicense(string5);
                        if (string12.equals("1")) {
                            oS400ProductLicense.setCodeType(1);
                        } else if (string12.equals("2")) {
                            oS400ProductLicense.setCodeType(2);
                        } else {
                            oS400ProductLicense.setCodeType(0);
                        }
                        oS400ProductLicense.setExpirationDate(string13);
                        oS400ProductLicense.setLicenseCode(string14);
                        oS400ProductLicense.setLicenseCount(n5);
                        licensedProduct.setLicense(oS400ProductLicense);
                        arrayList.add(licensedProduct);
                        continue;
                    }
                    logger.debug((Object)("Unknown license format for " + string5 + ": " + string10));
                }
                // ** MonitorExit[var5_3] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to retrieve the product license.", (Throwable)exception);
        }
        {
            licensedProductArray = new LicensedProduct[]{};
            licensedProductArray = arrayList.toArray(licensedProductArray);
            return licensedProductArray;
        }
    }
}

