/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.dm.IFSJavaFileDM;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.IFSJavaFile;
import com.ibm.as400.security.auth.ProfileTokenCredential;
import java.io.File;
import org.apache.log4j.Logger;

public class IFSJavaFileDMAS400
extends AbstractAS400Manager
implements IFSJavaFileDM {
    private static final Logger logger = Logger.getLogger(IFSJavaFileDMAS400.class);

    public IFSJavaFileDMAS400(String string, String string2) {
        super(string);
        this.setName(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getIFSJavaFile(UserIdentity userIdentity, String string, String string2, String string3) throws ResourceUnavailableException {
        ProfileTokenCredential profileTokenCredential = null;
        try {
            IFSJavaFile iFSJavaFile;
            profileTokenCredential = this.getProfileTokenCredential(userIdentity, string2);
            String string4 = string;
            if (string == null || string.trim().length() == 0) {
                string4 = "localhost";
            }
            AS400 aS400 = new AS400(string4, profileTokenCredential);
            IFSJavaFile iFSJavaFile2 = iFSJavaFile = new IFSJavaFile(aS400, string3);
            return iFSJavaFile2;
        }
        finally {
            if (profileTokenCredential != null) {
                super.releaseConnection(profileTokenCredential.getSystem());
            }
        }
    }

    private ProfileTokenCredential getProfileTokenCredential(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        ProfileTokenCredential profileTokenCredential = null;
        int n = 3600;
        try {
            wrappedAS400 = super.borrowConnection(userIdentity);
            CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
            String string2 = "CHKOBJ OBJ(" + string + ") OBJTYPE(*USRPRF) AUT(*USE)";
            commandCall.setCommand(string2);
            boolean bl = commandCall.run();
            if (!bl) {
                try {
                    AS400Message[] aS400MessageArray = commandCall.getMessageList();
                    String string3 = "N/A";
                    if (aS400MessageArray.length > 0) {
                        string3 = aS400MessageArray[0].getText();
                        for (int i = 0; i < aS400MessageArray.length; ++i) {
                            logger.debug((Object)(aS400MessageArray[i].getID() + ": " + aS400MessageArray[i].getText()));
                        }
                    }
                    throw new ResourceUnavailableException("Error validating authority to profile " + string + ": " + string3);
                }
                catch (Throwable throwable) {
                    super.releaseConnection(wrappedAS400);
                    throw throwable;
                }
            }
            profileTokenCredential = new ProfileTokenCredential();
            profileTokenCredential.setSystem((AS400)wrappedAS400);
            profileTokenCredential.setTimeoutInterval(n);
            profileTokenCredential.setTokenType(1);
            profileTokenCredential.setToken(string, 2);
            return profileTokenCredential;
        }
        catch (AS400SecurityException aS400SecurityException) {
            String string4 = "A Security Exception occurred while creating Profile Token Credential for user id " + string + ".";
            logger.debug((Object)string4, (Throwable)aS400SecurityException);
            throw new ResourceUnavailableException(string4, (Throwable)aS400SecurityException);
        }
        catch (Exception exception) {
            String string5 = "An error occurred while creating Profile Token Credential for user id " + string + ".";
            logger.debug((Object)string5, (Throwable)exception);
            throw new ResourceUnavailableException(string5, (Throwable)exception);
        }
    }

    @Override
    public void closeIFSJavaFile(File file) {
        if (file == null) {
            return;
        }
        if (!(file instanceof IFSJavaFile)) {
            throw new IllegalArgumentException("File to close must be an IFSJavaFile.");
        }
        IFSJavaFile iFSJavaFile = (IFSJavaFile)file;
        AS400 aS400 = iFSJavaFile.getSystem();
        if (aS400 != null) {
            aS400.disconnectAllServices();
        }
    }
}

