/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400CommonPCMLManager;
import com.helpsystems.common.as400.access.AS400ConnectionFactory;
import com.helpsystems.common.as400.access.AS400LoginHandlerAM;
import com.helpsystems.common.as400.access.AS400ObjectPool;
import com.helpsystems.common.as400.access.AS400PoolManager;
import com.helpsystems.common.as400.access.CcsidManager;
import com.helpsystems.common.as400.access.PCMLUtil;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400JobDescriptor;
import com.helpsystems.common.as400.busobj.OS400LibraryList;
import com.helpsystems.common.as400.ex.CommandCallException;
import com.helpsystems.common.as400.ex.CommandCallSecurityException;
import com.helpsystems.common.as400.ex.CommandExecutionMessage;
import com.helpsystems.common.as400.ex.CommandExecutionResponse;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.InvalidIdentityException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.MissingIdentityException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.dm.EncryptUtilAM;
import com.helpsystems.common.core.dm.UserIdentityAM;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ProgramCall;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Logger;

public abstract class AbstractAS400Manager
extends AbstractManager {
    private static final Logger logger = Logger.getLogger(AbstractAS400Manager.class);
    protected String poolName;
    protected String productLibrary = null;
    private OS400LibraryList libraryList = null;
    private int commandServerOverrideCcsid;
    private boolean overrideAS400ObjectCcsid;

    public AbstractAS400Manager(String string) {
        this(string, null);
    }

    public AbstractAS400Manager(String string, String string2) {
        this.poolName = string;
        if (string2 != null) {
            this.productLibrary = string2.trim().toUpperCase();
            if (this.productLibrary.length() > 0) {
                logger.trace((Object)("PCML Product Library was specified: " + this.productLibrary));
            }
        } else {
            this.productLibrary = null;
        }
    }

    public void setLibraryList(OS400LibraryList oS400LibraryList) {
        this.libraryList = oS400LibraryList;
    }

    public OS400LibraryList getLibraryList() {
        return this.libraryList;
    }

    private boolean isOverrideAS400ObjectCcsid() {
        return this.overrideAS400ObjectCcsid;
    }

    protected WrappedAS400 borrowConnection() throws ResourceUnavailableException {
        ObjectPool objectPool = AS400PoolManager.getInstance().getPool(this.poolName);
        if (objectPool == null) {
            throw new ResourceUnavailableException("Could not connect to  the AS400 Object Pool: " + this.poolName, null);
        }
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = (WrappedAS400)((Object)objectPool.borrowObject());
            if (logger.isTraceEnabled()) {
                AbstractAS400Manager.logCaller(wrappedAS400, "borrowed");
            }
            wrappedAS400.isClosed = false;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Could not retrieve a connection from pool: " + this.poolName, (Throwable)exception);
        }
        this.performCcsidAdjustments(wrappedAS400);
        this.setupUserLibl(wrappedAS400, null);
        return wrappedAS400;
    }

    private void performCcsidAdjustments(WrappedAS400 wrappedAS400) {
        int n;
        AbstractAS400Manager.validateCommandServerConnection(wrappedAS400);
        wrappedAS400.setAs400ObjectOverrideCcsid(0);
        if (this.isOverrideAS400ObjectCcsid() && (n = CcsidManager.ccsidOfUser()) != wrappedAS400.getCcsid()) {
            wrappedAS400.setAs400ObjectOverrideCcsid(n);
        }
        if (this.commandServerOverrideCcsid != 0) {
            this.overrideCommandServerCcsidIfNecessary(wrappedAS400);
        } else if (wrappedAS400.getCommandServerCcsidToRestore() != 0) {
            this.restoreCommandServerCcsid(wrappedAS400);
        }
    }

    private void overrideCommandServerCcsidIfNecessary(WrappedAS400 wrappedAS400) {
        CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
        Job job = AbstractAS400Manager.getCommandServerJob(commandCall);
        try {
            int n = job.getCodedCharacterSetID();
            switch (this.commandServerOverrideCcsid) {
                case 65535: {
                    if (n != this.commandServerOverrideCcsid && n != 37) {
                        this.changeCmdServerJobCcsid(commandCall, this.commandServerOverrideCcsid);
                    }
                    break;
                }
                case 37: {
                    if (n != this.commandServerOverrideCcsid && n != 65535) {
                        this.changeCmdServerJobCcsid(commandCall, this.commandServerOverrideCcsid);
                    }
                    break;
                }
                default: {
                    if (n != this.commandServerOverrideCcsid) {
                        this.changeCmdServerJobCcsid(commandCall, this.commandServerOverrideCcsid);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Error while attempting to change the CCSID of Job {0}.", (Object[])new Object[]{job.toString()});
            throw new RuntimeException(string, exception);
        }
    }

    private void changeCmdServerJobCcsid(CommandCall commandCall, int n) throws Exception {
        Job job = AbstractAS400Manager.getCommandServerJob(commandCall);
        int n2 = job.getCodedCharacterSetID();
        WrappedAS400 wrappedAS400 = (WrappedAS400)commandCall.getSystem();
        logger.trace((Object)MessageUtil.formatMsg((String)"Changing the CCSID of Remote Command Server Job {0} from {1} to {2}.", (Object[])new Object[]{job.toString(), Integer.toString(n2), Integer.toString(n)}));
        String string = MessageUtil.formatMsg((String)"CHGJOB CCSID({0})", (Object[])new Object[]{Integer.toString(n)});
        AbstractAS400Manager.runCommand(string, commandCall);
        wrappedAS400.setCommandServerCcsidToRestore(n2);
    }

    private void restoreCommandServerCcsid(WrappedAS400 wrappedAS400) {
        CommandCall commandCall = new CommandCall((AS400)wrappedAS400);
        try {
            String string = MessageUtil.formatMsg((String)"CHGJOB CCSID({0})", (Object[])new Object[]{Integer.toString(wrappedAS400.getCommandServerCcsidToRestore())});
            AbstractAS400Manager.runCommand(string, commandCall);
            wrappedAS400.setCommandServerCcsidToRestore(0);
        }
        catch (Exception exception) {
            Job job = AbstractAS400Manager.getCommandServerJob(commandCall);
            String string = MessageUtil.formatMsg((String)"Error while attempting to change the CCSID of Job {0}.", (Object[])new Object[]{job.toString()});
            throw new RuntimeException(string, exception);
        }
    }

    private static Job getCommandServerJob(CommandCall commandCall) {
        AbstractAS400Manager.validateCommandServerConnection(commandCall.getSystem());
        try {
            return commandCall.getServerJob();
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Error while attempting to retrieve the Command Server Job information associated with {0}.", (Object[])new Object[]{commandCall.getSystem().toString()});
            throw new RuntimeException(string, exception);
        }
    }

    private static void validateCommandServerConnection(AS400 aS400) {
        if (!aS400.isConnected(2)) {
            try {
                aS400.connectService(2);
            }
            catch (Exception exception) {
                String string = MessageUtil.formatMsg((String)"{0} has no connection to a Command Server.", (Object[])new Object[]{aS400.toString()});
                throw new IllegalStateException(string, exception);
            }
        }
    }

    private void setupUserLibl(WrappedAS400 wrappedAS400, OS400LibraryList oS400LibraryList) throws ResourceUnavailableException {
        OS400LibraryList oS400LibraryList2 = new OS400LibraryList();
        if (this.libraryList == null && this.productLibrary != null) {
            oS400LibraryList2.addLibrary(this.productLibrary);
        }
        if (this.libraryList != null) {
            oS400LibraryList2.appendLibraryList(this.libraryList);
        }
        if (oS400LibraryList != null) {
            oS400LibraryList2.appendLibraryList(oS400LibraryList);
        }
        wrappedAS400.setupUserLibl(oS400LibraryList2);
    }

    protected WrappedAS400 borrowConnection(UserIdentity userIdentity) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"UserIdentity", (Object)userIdentity);
        String string = null;
        char[] cArray = null;
        UserIdentity userIdentity2 = userIdentity;
        AS400ObjectPool aS400ObjectPool = (AS400ObjectPool)AS400PoolManager.getInstance().getPool(this.poolName);
        if (!userIdentity.equals((Object)UserIdentity.NO_USER_SPECIFIED) && !aS400ObjectPool.getDescriptor().getDirectConnectPool()) {
            userIdentity2 = this.findIdentity(userIdentity);
            string = userIdentity2.getName().toUpperCase();
            cArray = this.decodePassword(userIdentity2);
        }
        if (aS400ObjectPool.getDescriptor().getProhibitSwapping()) {
            logger.trace((Object)"AS400 user swapping is prohibited, creating a new connection for a user.");
            return this.setupLiblAndASP(this.createConnectionForUser(userIdentity2), userIdentity2);
        }
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection();
            if (aS400ObjectPool.getDescriptor().getDirectConnectPool()) {
                return this.setupLiblAndASP(wrappedAS400, userIdentity2);
            }
            if (string != null) {
                byte[] byArray = PCMLUtil.generateToken((AS400)wrappedAS400, string, cArray);
                boolean bl = PCMLUtil.swap(wrappedAS400, byArray);
                if (!bl) {
                    wrappedAS400.close();
                    throw new ResourceUnavailableException("Could not swap to user " + string + " on server " + userIdentity2.getSystem(), null);
                }
                userIdentity2.setPasswordState(1);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Swapped AS400 connection to user " + string));
                }
            }
            return this.setupLiblAndASP(wrappedAS400, userIdentity2);
        }
        catch (Exception exception) {
            if (wrappedAS400 != null) {
                try {
                    wrappedAS400.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            logger.debug((Object)("Unable to swap to user " + string + " on server " + userIdentity2.getSystem()), (Throwable)exception);
            return this.setupLiblAndASP(this.createConnectionForUser(userIdentity2), userIdentity2);
        }
    }

    private WrappedAS400 setupLiblAndASP(WrappedAS400 wrappedAS400, UserIdentity userIdentity) throws ResourceUnavailableException {
        if (userIdentity != null) {
            OS400LibraryList oS400LibraryList = (OS400LibraryList)((Object)userIdentity.getAttribute((Serializable)((Object)"os400.library_list")));
            String string = (String)((Object)userIdentity.getAttribute((Serializable)((Object)"os400.asp_group")));
            wrappedAS400.setASPGroup(string);
            this.setupUserLibl(wrappedAS400, oS400LibraryList);
        }
        return wrappedAS400;
    }

    protected final UserIdentity findIdentity(UserIdentity userIdentity) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = userIdentity;
        UserIdentityAM userIdentityAM = (UserIdentityAM)ManagerRegistry.getManagerOrFail((String)"COMMON.UserIdentityAM");
        try {
            userIdentity2 = userIdentityAM.findIdentity(userIdentity2, this.poolName);
        }
        catch (ActionFailedException actionFailedException) {
            throw new ResourceUnavailableException("An error occurred while looking up the user identity.", (Throwable)actionFailedException);
        }
        if (userIdentity2 == null) {
            String string = "localhost";
            try {
                AS400CommonPCMLManager aS400CommonPCMLManager = (AS400CommonPCMLManager)ManagerRegistry.getManagerOrFail((String)"COMMON.IAS400CommonPCMLManager");
                string = aS400CommonPCMLManager.retrieveSystemName();
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to look up the local system's name", (Throwable)exception);
            }
            throw new MissingIdentityException(string);
        }
        String string = userIdentity2.getName().toUpperCase();
        if (userIdentity2.getPasswordState() == 0) {
            char[] cArray = this.decodePassword(userIdentity2);
            AS400LoginHandlerAM aS400LoginHandlerAM = new AS400LoginHandlerAM("localhost");
            try {
                if (aS400LoginHandlerAM.validateUser(string, cArray) == null) {
                    userIdentity2.setPasswordState(1);
                } else {
                    userIdentity2.setPasswordState(-1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (userIdentity2.getPasswordState() == -1) {
            throw new InvalidIdentityException(userIdentity2);
        }
        return userIdentity2;
    }

    private final char[] decodePassword(UserIdentity userIdentity) throws ResourceUnavailableException {
        EncryptUtilAM encryptUtilAM = (EncryptUtilAM)ManagerRegistry.getManagerOrFail((String)"COMMON.EncryptUtilAM");
        try {
            return encryptUtilAM.decodeBase64ToChar(userIdentity.getEncryptedPassword());
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to decode the password for user " + userIdentity.getName() + " for server " + userIdentity.getSystem(), (Throwable)exception);
        }
    }

    protected WrappedAS400 createOneTimeUseConnection(UserIdentity userIdentity) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = userIdentity;
        ValidationHelper.checkForNull((String)"UserIdentity", (Object)userIdentity2);
        if (userIdentity2.equals((Object)UserIdentity.NO_USER_SPECIFIED)) {
            return this.borrowConnection();
        }
        AS400ObjectPool aS400ObjectPool = (AS400ObjectPool)AS400PoolManager.getInstance().getPool(this.poolName);
        if (aS400ObjectPool.getDescriptor().getDirectConnectPool()) {
            return this.borrowConnection();
        }
        userIdentity2 = this.findIdentity(userIdentity2);
        String string = userIdentity2.getName().toUpperCase();
        char[] cArray = this.decodePassword(userIdentity2);
        String string2 = aS400ObjectPool.getFactory().getServerAddress();
        WrappedAS400 wrappedAS400 = new WrappedAS400(string2, string);
        wrappedAS400.setPassword(new String(cArray));
        if (this.isOverrideAS400ObjectCcsid()) {
            wrappedAS400.setMustUseSockets(true);
        }
        try {
            wrappedAS400.validateSignon();
        }
        catch (Exception exception) {
            String string3 = MessageUtil.formatMsg((String)"Error trying to create a one-time use connection for user {0} on server {1}. Unable to validate the user.", (Object[])new Object[]{string, userIdentity2.getSystem()});
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        try {
            wrappedAS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        wrappedAS400.setOneTimeUse(true);
        AbstractAS400Manager.logCaller(wrappedAS400, "one-time-use created");
        return wrappedAS400;
    }

    protected WrappedAS400 createConnectionForUser(UserIdentity userIdentity) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = userIdentity;
        ValidationHelper.checkForNull((String)"UserIdentity", (Object)userIdentity2);
        String string = null;
        char[] cArray = null;
        if (userIdentity2.equals((Object)UserIdentity.NO_USER_SPECIFIED)) {
            return this.borrowConnection();
        }
        AS400ObjectPool aS400ObjectPool = (AS400ObjectPool)AS400PoolManager.getInstance().getPool(this.poolName);
        if (aS400ObjectPool.getDescriptor().getDirectConnectPool()) {
            return this.borrowConnection();
        }
        userIdentity2 = this.findIdentity(userIdentity2);
        string = userIdentity2.getName().toUpperCase();
        cArray = this.decodePassword(userIdentity2);
        aS400ObjectPool = (AS400ObjectPool)AS400PoolManager.getInstance().getPool(this.poolName);
        AS400ConnectionFactory aS400ConnectionFactory = aS400ObjectPool.getFactory();
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = (WrappedAS400)((Object)aS400ConnectionFactory.makeObject(string, new String(cArray)));
            wrappedAS400.setOneTimeUse(true);
            AbstractAS400Manager.logCaller(wrappedAS400, "one-time-use created");
            return wrappedAS400;
        }
        catch (Exception exception) {
            if (wrappedAS400 != null) {
                try {
                    wrappedAS400.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new ResourceUnavailableException("Unable to swap to user " + string + " on server " + userIdentity2.getSystem(), (Throwable)exception);
        }
    }

    protected void releaseConnection(AS400 aS400) {
        this.releaseConnection(aS400, false);
    }

    protected void releaseConnection(AS400 aS400, boolean bl) {
        Object object;
        if (aS400 == null) {
            return;
        }
        if (bl && this.productLibrary != null && this.productLibrary.trim().length() > 0) {
            try {
                object = "RMVLIBLE LIB(" + this.productLibrary + ")";
                CommandCall commandCall = new CommandCall(aS400, (String)object);
                commandCall.run();
            }
            catch (Exception exception) {
                String string = "Error removing product library (" + this.productLibrary + ") when releasing connection: " + exception.getMessage();
                logger.trace((Object)string);
            }
        }
        try {
            object = (WrappedAS400)aS400;
            object.close();
        }
        catch (Exception exception) {
            logger.debug((Object)("Exception thrown when releasing an AS400 connection to pool: " + this.poolName), (Throwable)exception);
        }
    }

    static void logCaller(WrappedAS400 wrappedAS400, String string) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        boolean bl = false;
        Throwable throwable = new Throwable("Stack trace");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            Object object;
            String string2 = stackTraceElementArray[i].getClassName();
            if (string2.indexOf("AbstractAS400Manager") > -1) {
                bl = true;
            }
            if (string2.indexOf("AbstractAS400Manager") > -1 || string2.indexOf("WrappedAS400") > -1 || !bl) continue;
            AS400ObjectPool aS400ObjectPool = wrappedAS400.getPool();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if (aS400ObjectPool != null) {
                n = aS400ObjectPool.getNumActive() + aS400ObjectPool.getNumIdle();
                n2 = aS400ObjectPool.getNumActive();
                n3 = aS400ObjectPool.getMaxActive();
            }
            String string3 = "Unavailable";
            String string4 = "Unavailable";
            String string5 = "Unavailable";
            try {
                object = wrappedAS400.getJobs(2);
                if (((Job[])object).length == 0) {
                    wrappedAS400.connectService(2);
                    object = wrappedAS400.getJobs(2);
                }
                Object object2 = object[0];
                string4 = object2.getName();
                string3 = object2.getNumber();
                string5 = object2.getUser();
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("AS400 Connection ");
            ((StringBuffer)object).append(System.identityHashCode((Object)wrappedAS400));
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(" (");
            ((StringBuffer)object).append(n2);
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(n);
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(n3);
            ((StringBuffer)object).append(") ");
            ((StringBuffer)object).append("Job ");
            ((StringBuffer)object).append(string3);
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(string5);
            ((StringBuffer)object).append("/");
            ((StringBuffer)object).append(string4);
            ((StringBuffer)object).append("\n\t");
            ((StringBuffer)object).append(stackTraceElementArray[i].toString());
            logger.trace((Object)((StringBuffer)object).toString());
            break;
        }
    }

    public static boolean runCommand(String string, CommandCall commandCall) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException {
        ValidationHelper.checkForNullAndBlank((String)"Command", (String)string);
        ValidationHelper.checkForNull((String)"Command Call", (Object)commandCall);
        AS400 aS400 = commandCall.getSystem();
        byte[] byArray = CharConverter.stringToByteArray((AS400)aS400, (String)string);
        try {
            return commandCall.run(byArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new RuntimeException("A PropertyVetoException occurred while attempting to run a command.", propertyVetoException);
        }
    }

    public static CommandExecutionResponse runCommand(String string, AS400 aS400) throws CommandCallException, CommandCallSecurityException {
        ValidationHelper.checkForNullAndBlank((String)"Command", (String)string);
        ValidationHelper.checkForNull((String)"AS400 object", (Object)aS400);
        CommandCall commandCall = new CommandCall(aS400);
        CommandExecutionResponse commandExecutionResponse = new CommandExecutionResponse(false);
        commandExecutionResponse.setCommand(string);
        try {
            Object object;
            Job job = commandCall.getServerJob();
            if (job != null) {
                object = (Object)new OS400JobDescriptor(job.getName(), job.getUser(), job.getNumber());
                commandExecutionResponse.setJobInfo((OS400JobDescriptor)((Object)object));
            }
            object = CharConverter.stringToByteArray((AS400)aS400, (String)string);
            boolean bl = commandCall.run(object);
            commandExecutionResponse.setSuccessful(bl);
            CommandExecutionResponse commandExecutionResponse2 = commandExecutionResponse;
            return commandExecutionResponse2;
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new CommandCallSecurityException(commandExecutionResponse, (Throwable)aS400SecurityException);
        }
        catch (Exception exception) {
            throw new CommandCallException(commandExecutionResponse, (Throwable)exception);
        }
        finally {
            CommandExecutionMessage[] commandExecutionMessageArray = AbstractAS400Manager.extractMessages(commandCall);
            commandExecutionResponse.setMessages(commandExecutionMessageArray);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandExecutionResponse runCommand(CommandCall commandCall, String string) throws CommandCallException, CommandCallSecurityException {
        CommandExecutionResponse commandExecutionResponse;
        if (commandCall == null) {
            throw new NullPointerException("The command call object cannot be null.");
        }
        if (string == null || string.trim().length() == 0) {
            throw new NullPointerException("A command is required.");
        }
        CommandExecutionResponse commandExecutionResponse2 = new CommandExecutionResponse(false);
        commandExecutionResponse2.setCommand(string);
        logger.debug((Object)("Executing command: " + string));
        try {
            Job job = commandCall.getServerJob();
            if (job != null) {
                OS400JobDescriptor oS400JobDescriptor = new OS400JobDescriptor(job.getName(), job.getUser(), job.getNumber());
                commandExecutionResponse2.setJobInfo(oS400JobDescriptor);
            }
            boolean bl = commandCall.run(string);
            commandExecutionResponse2.setSuccessful(bl);
            commandExecutionResponse = commandExecutionResponse2;
        }
        catch (AS400SecurityException aS400SecurityException) {
            try {
                throw new CommandCallSecurityException(commandExecutionResponse2, (Throwable)aS400SecurityException);
                catch (Exception exception) {
                    throw new CommandCallException(commandExecutionResponse2, (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                logger.debug((Object)("Command completed successfully: " + commandExecutionResponse2.isSuccessful()));
                AS400Message[] aS400MessageArray = commandCall.getMessageList();
                CommandExecutionMessage[] commandExecutionMessageArray = new CommandExecutionMessage[aS400MessageArray.length];
                int n = 0;
                while (true) {
                    if (n >= aS400MessageArray.length) {
                        commandExecutionResponse2.setMessages(commandExecutionMessageArray);
                        throw throwable;
                    }
                    CommandExecutionMessage commandExecutionMessage = new CommandExecutionMessage();
                    Calendar calendar = aS400MessageArray[n].getDate();
                    if (calendar != null) {
                        commandExecutionMessage.setDateTimeSent(calendar.getTimeInMillis());
                    }
                    commandExecutionMessage.setMessageID(aS400MessageArray[n].getID());
                    commandExecutionMessage.setMessageFile(aS400MessageArray[n].getFileName());
                    commandExecutionMessage.setMessageFileLib(aS400MessageArray[n].getLibraryName());
                    commandExecutionMessage.setText(aS400MessageArray[n].getText());
                    commandExecutionMessage.setSecondLevelText(aS400MessageArray[n].getHelp());
                    commandExecutionMessage.setSeverity(aS400MessageArray[n].getSeverity());
                    commandExecutionMessage.setType(aS400MessageArray[n].getType());
                    commandExecutionMessageArray[n] = commandExecutionMessage;
                    logger.debug((Object)("  Message ID: " + commandExecutionMessage.getMessageID() + "  Sev: " + commandExecutionMessage.getSeverity() + "  Type: " + CommandExecutionMessage.getTypeText(commandExecutionMessage.getType()) + "  Text: " + commandExecutionMessage.getText()));
                    ++n;
                }
            }
        }
        logger.debug((Object)("Command completed successfully: " + commandExecutionResponse2.isSuccessful()));
        AS400Message[] aS400MessageArray = commandCall.getMessageList();
        CommandExecutionMessage[] commandExecutionMessageArray = new CommandExecutionMessage[aS400MessageArray.length];
        int n = 0;
        while (true) {
            if (n >= aS400MessageArray.length) {
                commandExecutionResponse2.setMessages(commandExecutionMessageArray);
                return commandExecutionResponse;
            }
            CommandExecutionMessage commandExecutionMessage = new CommandExecutionMessage();
            Calendar calendar = aS400MessageArray[n].getDate();
            if (calendar != null) {
                commandExecutionMessage.setDateTimeSent(calendar.getTimeInMillis());
            }
            commandExecutionMessage.setMessageID(aS400MessageArray[n].getID());
            commandExecutionMessage.setMessageFile(aS400MessageArray[n].getFileName());
            commandExecutionMessage.setMessageFileLib(aS400MessageArray[n].getLibraryName());
            commandExecutionMessage.setText(aS400MessageArray[n].getText());
            commandExecutionMessage.setSecondLevelText(aS400MessageArray[n].getHelp());
            commandExecutionMessage.setSeverity(aS400MessageArray[n].getSeverity());
            commandExecutionMessage.setType(aS400MessageArray[n].getType());
            commandExecutionMessageArray[n] = commandExecutionMessage;
            logger.debug((Object)("  Message ID: " + commandExecutionMessage.getMessageID() + "  Sev: " + commandExecutionMessage.getSeverity() + "  Type: " + CommandExecutionMessage.getTypeText(commandExecutionMessage.getType()) + "  Text: " + commandExecutionMessage.getText()));
            ++n;
        }
    }

    public static CommandExecutionMessage[] extractMessages(CommandCall commandCall) {
        CommandExecutionMessage[] commandExecutionMessageArray;
        CharConverter charConverter = null;
        CharConverter charConverter2 = null;
        int n = commandCall.getSystem().getCcsid();
        try {
            int n2 = AbstractAS400Manager.getCommandServerJob(commandCall).getCodedCharacterSetID();
            if (n2 != 65535 && n2 != n) {
                charConverter = new CharConverter(n2);
                charConverter2 = new CharConverter(n);
            }
        }
        catch (Exception exception) {
            commandExecutionMessageArray = "Error in extractMessages.";
            logger.debug((Object)commandExecutionMessageArray, (Throwable)exception);
        }
        AS400Message[] aS400MessageArray = commandCall.getMessageList();
        commandExecutionMessageArray = new CommandExecutionMessage[aS400MessageArray.length];
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            CommandExecutionMessage commandExecutionMessage = new CommandExecutionMessage();
            Calendar calendar = aS400MessageArray[i].getDate();
            if (calendar != null) {
                commandExecutionMessage.setDateTimeSent(calendar.getTimeInMillis());
            }
            commandExecutionMessage.setMessageID(aS400MessageArray[i].getID());
            commandExecutionMessage.setMessageFile(AbstractAS400Manager.convertText(aS400MessageArray[i].getFileName(), charConverter, charConverter2));
            commandExecutionMessage.setMessageFileLib(AbstractAS400Manager.convertText(aS400MessageArray[i].getLibraryName(), charConverter, charConverter2));
            commandExecutionMessage.setText(AbstractAS400Manager.convertText(aS400MessageArray[i].getText(), charConverter, charConverter2));
            commandExecutionMessage.setSecondLevelText(AbstractAS400Manager.convertText(aS400MessageArray[i].getHelp(), charConverter, charConverter2));
            commandExecutionMessage.setSeverity(aS400MessageArray[i].getSeverity());
            commandExecutionMessage.setType(aS400MessageArray[i].getType());
            commandExecutionMessageArray[i] = commandExecutionMessage;
            String string = MessageUtil.formatMsg((String)"  Message ID: {0}  Sev: {1}  Type: {2}  Text: {3}", (Object[])new Object[]{commandExecutionMessage.getMessageID(), Integer.toString(commandExecutionMessage.getSeverity()), CommandExecutionMessage.getTypeText(commandExecutionMessage.getType()), commandExecutionMessage.getText()});
            logger.debug((Object)string);
        }
        return commandExecutionMessageArray;
    }

    private static String convertText(String string, CharConverter charConverter, CharConverter charConverter2) {
        if (string != null && charConverter != null && charConverter2 != null) {
            return charConverter2.byteArrayToString(charConverter.stringToByteArray(string));
        }
        return string;
    }

    public static void runProgram(ProgramCall programCall) throws ResourceUnavailableException {
        Object object;
        ValidationHelper.checkForNull((String)"Program", (Object)programCall);
        try {
            Job[] jobArray = programCall.getSystem().getJobs(2);
            if (jobArray.length == 0) {
                programCall.getSystem().connectService(2);
                jobArray = programCall.getSystem().getJobs(2);
            }
            object = jobArray[0];
            object.setInquiryMessageReply("*DFT");
            if (object.getCacheChanges()) {
                object.commitChanges();
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to set job/message preferences.", (Throwable)exception);
        }
        boolean bl = false;
        try {
            bl = programCall.run();
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to run program  " + programCall.getProgram(), (Throwable)exception);
        }
        if (!bl) {
            object = AbstractAS400Manager.messagesToString(programCall.getMessageList());
            throw new ResourceUnavailableException("Error running program  " + programCall.getProgram() + ": " + (String)object, null);
        }
    }

    public static String messagesToString(AS400Message[] aS400MessageArray) {
        if (aS400MessageArray == null || aS400MessageArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string2 = aS400MessageArray[i].getID();
            String string3 = aS400MessageArray[i].getText();
            stringBuffer.append(string2);
            stringBuffer.append(" - ");
            stringBuffer.append(string3);
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String messagesToString(CommandExecutionMessage[] commandExecutionMessageArray) {
        if (commandExecutionMessageArray == null || commandExecutionMessageArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = 0; i < commandExecutionMessageArray.length; ++i) {
            stringBuffer.append(commandExecutionMessageArray[i].getMessageID());
            stringBuffer.append(" - ");
            stringBuffer.append(commandExecutionMessageArray[i].getText());
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void setOverrideAS400ObjectCcsid(boolean bl) {
        this.overrideAS400ObjectCcsid = bl;
    }

    public void setCommandServerOverrideCcsid(int n) {
        this.commandServerOverrideCcsid = n;
    }
}

