/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.dm.IUserListManager;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;

public class AS400UserListManager
extends AbstractAS400Manager
implements IUserListManager {
    private static final String CLOSE_PGM = "/QSYS.LIB/QGY.LIB/QGYCLST.PGM";
    private static final String LIST_API_PGM = "/QSYS.LIB/QGY.LIB/QGYOLAUS.PGM";
    private static final String GET_LIST_PGM = "/QSYS.LIB/QGY.LIB/QGYGTLE.PGM";
    private static final int F_SIZE = 12;

    public AS400UserListManager(String string, String string2) {
        super(string);
        this.setName(string2);
    }

    public String[] getUsers(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            String[] stringArray = this.getUserList(wrappedAS400, string);
            return stringArray;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve a list of users.", (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private synchronized String[] getUserList(AS400 aS400, String string) throws Exception {
        String[] stringArray = new String[]{};
        byte[] byArray = this.getList(aS400, string);
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 8, byArray2, 0, 4);
        if (byArray == null) {
            return stringArray;
        }
        int n = BinaryConverter.byteArrayToInt((byte[])byArray, (int)0);
        int n2 = n * 12;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(BinaryConverter.intToByteArray((int)n2)), new ProgramParameter(byArray2), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray((int)n)), new ProgramParameter(BinaryConverter.intToByteArray((int)1)), new ProgramParameter(BinaryConverter.intToByteArray((int)0))};
        ProgramCall programCall = new ProgramCall(aS400, GET_LIST_PGM, programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        CharConverter charConverter = new CharConverter();
        byte[] byArray3 = programParameterArray[0].getOutputData();
        stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < stringArray.length) {
            stringArray[n3] = charConverter.byteArrayToString(byArray3, n4, 10).trim();
            ++n3;
            n4 += 12;
        }
        this.closeList(aS400, byArray2);
        return stringArray;
    }

    private synchronized byte[] getList(AS400 aS400, String string) throws Exception {
        ProgramCall programCall;
        byte[] byArray = null;
        int n = 8;
        if (string != null && string.trim().length() > 0) {
            n = 9;
            byArray = CharConverter.stringToByteArray((AS400)aS400, (String)string);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[n];
        programParameterArray[0] = new ProgramParameter(0);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray((int)0));
        programParameterArray[2] = new ProgramParameter(80);
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray((int)-1));
        programParameterArray[4] = new ProgramParameter(CharConverter.stringToByteArray((AS400)aS400, (String)"AUTU0100"));
        programParameterArray[5] = new ProgramParameter(CharConverter.stringToByteArray((AS400)aS400, (String)"*ALL      "));
        programParameterArray[6] = new ProgramParameter(CharConverter.stringToByteArray((AS400)aS400, (String)"*NONE     "));
        programParameterArray[7] = new ProgramParameter(BinaryConverter.intToByteArray((int)0));
        if (n == 9) {
            programParameterArray[8] = new ProgramParameter(byArray);
        }
        if (!(programCall = new ProgramCall(aS400, LIST_API_PGM, programParameterArray)).run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        return programParameterArray[2].getOutputData();
    }

    private synchronized void closeList(AS400 aS400, byte[] byArray) throws Exception {
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(byArray), new ProgramParameter(new byte[8])};
        ProgramCall programCall = new ProgramCall(aS400, CLOSE_PGM, programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
    }
}

