/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400ConnectionFactory;
import com.helpsystems.common.as400.access.AS400ObjectPool;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class AS400PoolManager {
    private Hashtable<String, ObjectPool> poolTable;
    private static AS400PoolManager theInstance;

    private AS400PoolManager() {
        theInstance = this;
        this.poolTable = new Hashtable();
    }

    public static AS400PoolManager getInstance() {
        if (theInstance == null) {
            new AS400PoolManager();
        }
        return theInstance;
    }

    public ObjectPool getPool(String string) {
        return this.poolTable.get(string);
    }

    public void registerPool(String string, ObjectPool objectPool) {
        if (objectPool == null) {
            throw new NullPointerException("The pool passed in was null.");
        }
        if (string == null) {
            throw new NullPointerException("The name passed in was null.");
        }
        this.poolTable.put(string, objectPool);
    }

    public Collection getPoolNames() {
        return this.poolTable.keySet();
    }

    public Collection getPools() {
        return this.poolTable.values();
    }

    public ObjectPool removePool(String string) throws Exception {
        ObjectPool objectPool = this.poolTable.remove(string);
        objectPool.close();
        return objectPool;
    }

    public static String createTempPool(String string, String string2, String string3) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"System name", (Object)string);
        ValidationHelper.checkForNull((String)"User name", (Object)string2);
        ValidationHelper.checkForNull((String)"User password", (Object)string3);
        AS400ConnectionFactory aS400ConnectionFactory = new AS400ConnectionFactory(string, string2, string3);
        try {
            ValidationHelper.checkForNull((String)"Factory name", (Object)aS400ConnectionFactory);
            WrappedAS400 wrappedAS400 = (WrappedAS400)((Object)aS400ConnectionFactory.makeObject());
            ValidationHelper.checkForNull((String)"Wrapped w400", (Object)((Object)wrappedAS400));
            TempAS400ObjectPool tempAS400ObjectPool = new TempAS400ObjectPool(wrappedAS400);
            ValidationHelper.checkForNull((String)"Pool", (Object)((Object)tempAS400ObjectPool));
            wrappedAS400.setPool(tempAS400ObjectPool);
            String string4 = string.toUpperCase() + System.currentTimeMillis();
            AS400PoolManager.getInstance().registerPool(string4, (ObjectPool)tempAS400ObjectPool);
            return string4;
        }
        catch (Exception exception) {
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            throw new ResourceUnavailableException("Unable to create a connection pool.", (Throwable)exception);
        }
    }

    static class TempAS400ObjectPool
    extends AS400ObjectPool {
        WrappedAS400 as400;

        TempAS400ObjectPool(WrappedAS400 wrappedAS400) {
            super(null);
            this.as400 = wrappedAS400;
        }

        public void addObject() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public Object borrowObject() {
            return this.as400;
        }

        public void clear() {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void close() {
            this.as400.disconnectAllServices();
        }

        public int getNumActive() {
            return 1;
        }

        public int getNumIdle() {
            return 0;
        }

        @Override
        public void invalidateObject(Object object) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void returnObject(Object object) {
        }

        public void setFactory(PoolableObjectFactory poolableObjectFactory) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

