/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoBackgroundUnitAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionUnitState;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoResponse;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoUnitIdentifier;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.ext.SessionReferenceProvider;
import com.sap.conn.jco.rt.AbapFunction;
import com.sap.conn.jco.rt.AbapFunctionUnit;
import com.sap.conn.jco.rt.CallbackHandler;
import com.sap.conn.jco.rt.Context;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.jco.rt.DefaultRequest;
import com.sap.conn.jco.rt.DefaultResponse;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.ExtendedCallHandlerFactory;
import com.sap.conn.jco.rt.ServerAuthorizationData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.ServerWorker;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoApplicationAuthorizationException;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerCallType;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerFunctionHandlerFactory;
import com.sap.conn.jco.server.JCoServerRequestHandler;
import com.sap.conn.jco.server.JCoServerRequestHandlerFactory;
import com.sap.conn.jco.server.JCoServerRunnable;
import com.sap.conn.jco.server.JCoServerSecurityHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import com.sap.conn.jco.server.JCoServerUnitIDHandler;
import com.sap.conn.jco.util.FastStringBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DefaultServerWorker
extends ServerWorker
implements JCoServerRunnable {
    private static ThreadLocal<DefaultServerWorker> localWorker = new ThreadLocal();
    private static DenyTxHandler denyTxHandler = new DenyTxHandler();
    private CallbackHandler callbackHandler = new CallbackHandlerImpl();
    protected JCoServerSecurityHandler securityHandler;
    protected JCoServerTIDHandler tidManager = denyTxHandler;
    protected JCoServerUnitIDHandler unitIDHandler = denyTxHandler;
    protected JCoServerCallHandlerFactory sessionManager;
    protected ServerContext ctx = new ServerContext();
    protected CallDispatcher callDispatcher;
    boolean stopping = false;
    volatile Thread workerThread = null;
    private volatile SessionReferenceProvider sessionRefProvider = null;
    private volatile boolean sessionProviderNotified = false;

    protected DefaultServerWorker(DefaultServer server) {
        this.server = server;
        JCoServerCallHandlerFactory callHandlerFactory = server.getCallHandlerFactory();
        if (callHandlerFactory instanceof JCoServerFunctionHandlerFactory) {
            this.callDispatcher = new FunctionDispatcher((JCoServerFunctionHandlerFactory)callHandlerFactory);
        } else if (callHandlerFactory instanceof JCoServerRequestHandlerFactory) {
            this.callDispatcher = new RequestDispatcher((JCoServerRequestHandlerFactory)callHandlerFactory);
        }
        JCoServerTIDHandler serverTIDHandler = server.getTIDHandler();
        if (serverTIDHandler != null) {
            this.tidManager = serverTIDHandler;
        }
        this.securityHandler = server.getSecurityHandler();
        this.sessionManager = callHandlerFactory;
        JCoServerUnitIDHandler serverUnitIDHandler = server.getUnitIDHandler();
        if (serverUnitIDHandler != null) {
            this.unitIDHandler = serverUnitIDHandler;
        }
    }

    protected static DefaultServerWorker getThreadLocalServerWorker() {
        return localWorker.get();
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public JCoServerContext getContext() throws IllegalStateException {
        ServerConnection sConn = this.getConnection();
        if (sConn == null || !sConn.isValid()) {
            throw new IllegalStateException("connection\twas\tnot\tassigned or\twas\talready\tremoved");
        }
        return this.ctx;
    }

    protected void fireServerErrorOccurred(Error error) {
        this.server.fireServerErrorOccurred(this, this.conn, error);
    }

    protected void fireServerExceptionOccurred(Exception exception) {
        this.server.fireServerExceptionOccurred(this, this.conn, exception);
    }

    protected boolean checkAuthorization(String functionName, ServerAuthorizationData authData) {
        if (this.securityHandler != null) {
            try {
                this.securityHandler.checkAuthorization(this.ctx, functionName, authData);
            }
            catch (JCoApplicationAuthorizationException ae) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTraceCritical("Application declines the authorization", ae);
                }
                return false;
            }
            catch (Throwable th) {
                if (Trace.isOn(2, true)) {
                    Trace.fireTraceCritical("security handler throws error on authorization\trequest", th);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchRequest(JCoFunction function) throws AbapException, AbapClassException {
        try {
            localWorker.set(this);
            this.callDispatcher.handleRequest(this.ctx, function);
            Object var3_2 = null;
            localWorker.set(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            localWorker.set(null);
            throw throwable;
        }
    }

    protected JCoFunction getFunction(String functionName) throws JCoException {
        try {
            return this.callDispatcher.getFunction(this.ctx, functionName);
        }
        catch (RuntimeException ex) {
            this.fireServerExceptionOccurred(ex);
            throw ex;
        }
    }

    JCoRepository getRepository() {
        return this.server.getRepository(this.ctx);
    }

    void destroy() {
        this.workerThread = null;
        this.conn = null;
        this.server = null;
    }

    public Thread getThread() {
        return this.workerThread;
    }

    protected boolean onCheckTID(String tid) {
        this.ctx.tid = tid;
        return this.tidManager.checkTID(this.ctx, tid);
    }

    protected void onCommit(String tid) {
        this.ctx.tid = tid;
        this.tidManager.commit(this.ctx, tid);
    }

    protected void onConfirmTID(String tid) {
        this.tidManager.confirmTID(this.ctx, tid);
    }

    protected void onRollback(String tid) {
        this.ctx.tid = null;
        this.tidManager.rollback(this.ctx, tid);
    }

    public void run() {
        this.workerThread = Thread.currentThread();
        this.loop();
        if (Trace.isOn(16)) {
            Trace.fireTrace(16, new StringBuffer("[JCoAPI]\tJCoServer.run()\tleave run method in\t").append(Thread.currentThread().getName()).append(" thread").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void dispatch() {
        block34: {
            if (Trace.isOn(32)) {
                StringBuilder sb = new StringBuilder();
                sb.append("[JCoAPI]\tJCoServer.dispatch ").append(this.getThread().getName()).append(": handle ");
                if (this.conn != null) {
                    sb.append(this.conn.getConnectionHandle());
                } else {
                    sb.append("null");
                }
                Trace.fireTrace(32, sb.toString());
            }
            if (this.conn == null && Trace.isOn(4, true)) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                Throwable t = new Throwable();
                t.fillInStackTrace();
                t.printStackTrace(pw);
                pw.close();
                Trace.fireTrace(4, "ERROR: connection null in JCO.Server.work" + sw.getBuffer().toString());
            }
            String lastErrorMsg = null;
            try {
                this.conn.middlewareServer.listen(this);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                block35: {
                    Object var8_11 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (!Trace.isOn(4, true)) break block35;
                            Trace.fireTrace(4, new StringBuffer("[JCoAPI] Error\tduring sending the error message [").append(lastErrorMsg).append("] to\tbackend: ").append(t.toString()).toString());
                        }
                    }
                }
                throw throwable;
            }
            if (lastErrorMsg != null && this.conn.isValid()) {
                this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                try {
                    this.abort(lastErrorMsg);
                }
                catch (Throwable t) {
                    if (Trace.isOn(4, true)) {
                        Trace.fireTrace(4, new StringBuffer("[JCoAPI] Error\tduring sending the error message [").append(lastErrorMsg).append("] to\tbackend: ").append(t.toString()).toString());
                    }
                }
            }
            break block34;
            {
                catch (JCoException ex) {
                    String shortKey;
                    this.fireServerExceptionOccurred(ex);
                    switch (ex.getGroup()) {
                        case 104: {
                            shortKey = "";
                            break;
                        }
                        case 113: {
                            DefaultServer.RequestQueue requestQueue = this.server.getRequestQueue();
                            synchronized (requestQueue) {
                                JCoServerState state = this.server.getState();
                                if (state != JCoServerState.STOPPING && state != JCoServerState.STOPPED) {
                                    this.server.stop();
                                }
                            }
                            shortKey = "";
                            break;
                        }
                        case 102: {
                            shortKey = "COMMUNICATION_FAILURE ";
                            break;
                        }
                        default: {
                            shortKey = ex.getKey() + ":\t";
                        }
                    }
                    lastErrorMsg = shortKey + ex.getMessage();
                    Object var8_8 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn(4, true)) {
                                Trace.fireTrace(4, new StringBuffer("[JCoAPI] Error\tduring sending the error message [").append(lastErrorMsg).append("] to\tbackend: ").append(t.toString()).toString());
                            }
                        }
                    }
                    break block34;
                }
                catch (Exception ex) {
                    this.fireServerExceptionOccurred(ex);
                    lastErrorMsg = ex.toString();
                    Object var8_9 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn(4, true)) {
                                Trace.fireTrace(4, new StringBuffer("[JCoAPI] Error\tduring sending the error message [").append(lastErrorMsg).append("] to\tbackend: ").append(t.toString()).toString());
                            }
                        }
                    }
                    break block34;
                }
                catch (Error err) {
                    this.fireServerErrorOccurred(err);
                    lastErrorMsg = err.toString();
                    Object var8_10 = null;
                    if (lastErrorMsg != null && this.conn.isValid()) {
                        this.setState((byte)(this.conn.state & 0xFFFFFFF7));
                        try {
                            this.abort(lastErrorMsg);
                        }
                        catch (Throwable t) {
                            if (Trace.isOn(4, true)) {
                                Trace.fireTrace(4, new StringBuffer("[JCoAPI] Error\tduring sending the error message [").append(lastErrorMsg).append("] to\tbackend: ").append(t.toString()).toString());
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loop() {
        while (!this.stopping) {
            Object var6_4;
            DefaultServer.RequestQueue requestQueue = this.server.getRequestQueue();
            synchronized (requestQueue) {
                this.conn = this.server.getRequestQueue().getRequest();
            }
            try {
                if (this.conn != null) {
                    Object var4_3;
                    try {
                        try {
                            this.dispatch();
                        }
                        catch (Throwable t) {
                            Trace.fireTraceCritical("[JCoAPI] ERROR: exception in dispatch ", t);
                            var4_3 = null;
                            this.server.getRequestQueue().requestFinished();
                        }
                        var4_3 = null;
                        this.server.getRequestQueue().requestFinished();
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        this.server.getRequestQueue().requestFinished();
                        throw throwable;
                    }
                }
                var6_4 = null;
                if (this.server == null) continue;
                this.server.releaseListener(this);
            }
            catch (Throwable throwable) {
                var6_4 = null;
                if (this.server != null) {
                    this.server.releaseListener(this);
                }
                throw throwable;
            }
        }
        this.server.removeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void abort(String message) throws JCoException {
        if (Trace.isOn(4, true)) {
            Trace.fireTrace(4, "[JCoAPI] JCoServer.abort(\"" + message + "\") on\t[" + this.conn.getConnectionHandle() + "]");
        }
        try {
            if (this.isValid()) {
                this.conn.middlewareServer.abort(this, message);
            }
            Object var3_2 = null;
            this.setState((byte)(this.conn.state & 0xFFFFFFF7));
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setState((byte)(this.conn.state & 0xFFFFFFF7));
            throw throwable;
        }
    }

    void removeConnectionHandle() {
        this.conn.serverGroup.removeConnection(this.conn);
    }

    final String callStartedInternal() {
        String currentSessionID = null;
        if (this.sessionRefProvider == null) {
            this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callStartedInternal(), SessionRefProvider is\t" + (this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()));
        }
        if (this.sessionRefProvider != null) {
            try {
                currentSessionID = this.conn.getSessionId();
                if (currentSessionID == null) {
                    JCoSessionReference ref = this.sessionRefProvider.jcoServerSessionStarted();
                    currentSessionID = ref != null ? ref.getID() : this.conn.getConversationID();
                } else {
                    this.sessionRefProvider.jcoServerSessionContinued(currentSessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation\tof the SessionReferenceProvider\tthrows " + e.toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation\tof the SessionReferenceProvider\tthrows " + e.toString(), e);
                }
                throw e;
            }
            this.sessionProviderNotified = true;
            this.server.increaseRequestsInProcess();
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callStartedInternal() for session ID " + currentSessionID + " leave");
        }
        return currentSessionID;
    }

    final void callFinishedInternal(String currentSessionID) {
        if (this.sessionRefProvider == null) {
            this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
        }
        if (Trace.isOn(128)) {
            Trace.fireTrace(128, "[JcoAPI] JCoServer.callFinishedInternal(), SessionRefProvider is " + (this.sessionRefProvider == null ? "null" : this.sessionRefProvider.getClass().getName()));
        }
        this.server.decreaseRequestsInProcess();
        if (this.sessionRefProvider != null) {
            try {
                String sessionID = this.conn.getSessionId();
                if (sessionID == null) {
                    this.sessionRefProvider.jcoServerSessionFinished(currentSessionID);
                } else {
                    this.sessionRefProvider.jcoServerSessionPassivated(sessionID);
                }
            }
            catch (RuntimeException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation\tof the SessionReferenceProvider\tthrows " + e.toString(), e);
                }
                throw e;
            }
            catch (Error e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] implementation\tof the SessionReferenceProvider\tthrows " + e.toString(), e);
                }
                throw e;
            }
            this.sessionProviderNotified = false;
        }
    }

    protected void onSessionClose(String message, boolean error) {
        block16: {
            String sessionID;
            block15: {
                Context context;
                block14: {
                    block13: {
                        if (this.sessionRefProvider == null) {
                            this.sessionRefProvider = DefaultServer.jcoRuntime.getSessionReferenceProvider();
                        }
                        sessionID = this.conn.getSessionId();
                        if (this.sessionRefProvider != null && !this.sessionProviderNotified && sessionID != null) {
                            try {
                                this.sessionRefProvider.jcoServerSessionContinued(sessionID);
                            }
                            catch (Throwable th) {
                                if (!Trace.isOn(4)) break block13;
                                Trace.fireTrace(4, "[JCoAPI] jcoServerSessionContinued() throws:" + th.toString(), th);
                            }
                        }
                    }
                    if (Trace.isOn(128)) {
                        Trace.fireTrace(128, "[JcoAPI] ServerWorker.onSessionClose(): session is closed");
                    }
                    try {
                        this.sessionManager.sessionClosed(this.ctx, message, error);
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4)) break block14;
                        Trace.fireTrace(4, "[JCoAPI] sessionClosed() throws:" + th.toString(), th);
                    }
                }
                if (sessionID != null && (context = DefaultServer.jcoRuntime.getRuntimeContext(sessionID, false)) != null) {
                    try {
                        context.setServerConnection(null);
                        DefaultServer.jcoRuntime.releaseRuntimeContext(context);
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(4)) break block15;
                        Trace.fireTrace(4, "[JCoAPI] releaseRuntimeContext() in\tonSessionClose throws:" + th.toString(), th);
                    }
                }
            }
            if (this.sessionRefProvider != null) {
                try {
                    this.sessionRefProvider.jcoServerSessionFinished(sessionID);
                }
                catch (Throwable th) {
                    if (!Trace.isOn(4)) break block16;
                    Trace.fireTrace(4, "[JCoAPI] jcoServerSessionFinished()\tthrows:" + th.toString(), th);
                }
            }
        }
    }

    void setState(byte state) {
        this.conn.state = state;
    }

    byte getState() {
        return this.conn.state;
    }

    private static class DenyTxHandler
    implements JCoServerTIDHandler,
    JCoServerUnitIDHandler {
        private DenyTxHandler() {
        }

        public boolean checkUnitID(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public void commit(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public void confirmUnitID(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public JCoFunctionUnitState getFunctionUnitState(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public void rollback(JCoServerContext serverCtx, JCoUnitIdentifier unitIdentifier) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No background unit handler is installed. Unable to process bgRFC units.");
        }

        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        public void commit(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        public void confirmTID(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }

        public void rollback(JCoServerContext serverCtx, String tid) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "No transaction handler is installed. Unable to process tRFC/qRFC requests.");
        }
    }

    public class RequestDispatcher
    extends CallDispatcher {
        private JCoServerRequestHandlerFactory aFactory;

        public RequestDispatcher(JCoServerRequestHandlerFactory factory) {
            super(factory);
            this.aFactory = factory;
        }

        protected JCoServerRequestHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            JCoServerRequestHandler handler = this.aFactory.getCallHandler(serverCtx, function.getName());
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuffer("the call handler factory [").append(this.aFactory.getClass().getName()).append("] returns null\tfor\tthe\tfunction ").append(function.getName()).toString());
            }
            DefaultRequest request = new DefaultRequest(function);
            DefaultResponse response = request.getResponse();
            handler.handleRequest(serverCtx, request, response);
            return handler;
        }
    }

    public class FunctionDispatcher
    extends CallDispatcher {
        private JCoServerFunctionHandlerFactory aFactory;

        public FunctionDispatcher(JCoServerFunctionHandlerFactory factory) {
            super(factory);
            this.aFactory = factory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected JCoServerFunctionHandler handleRequest(JCoServerContext serverCtx, JCoFunction function) throws AbapException, AbapClassException {
            Object buf;
            JCoServerFunctionHandler handler;
            block13: {
                block12: {
                    FastStringBuffer buf22222;
                    String errorMsg = null;
                    handler = null;
                    try {
                        try {
                            if (Trace.isOn(64)) {
                                buf = new FastStringBuffer(120).append("[JCoAPI] JCoServer\tdispatches (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" before getCallHandler()");
                                Trace.fireTrace(64, ((FastStringBuffer)buf).toString());
                            }
                            handler = this.aFactory.getCallHandler(serverCtx, function.getName());
                        }
                        catch (RuntimeException re) {
                            errorMsg = re.toString();
                            throw re;
                        }
                        catch (Error er) {
                            errorMsg = er.toString();
                            throw er;
                        }
                        Object var7_8 = null;
                        if (errorMsg == null) break block12;
                        buf22222 = new FastStringBuffer(120).append("[JCoAPI] JCoServer\tdispatches (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" getCallHandler() thrown ").append(errorMsg);
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (errorMsg != null) {
                            FastStringBuffer buf22222 = new FastStringBuffer(120).append("[JCoAPI] JCoServer\tdispatches (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" getCallHandler() thrown ").append(errorMsg);
                            Trace.fireTrace(4, buf22222.toString());
                            throw throwable;
                        }
                        if (!Trace.isOn(64)) throw throwable;
                        FastStringBuffer buf3 = new FastStringBuffer(120).append("[JCoAPI] JCoServer\tdispatches (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" after\tgetCallHandler(), factory is ").append(handler == null ? "null" : handler.getClass().getName());
                        Trace.fireTrace(64, buf3.toString());
                        throw throwable;
                    }
                    Trace.fireTrace(4, buf22222.toString());
                    break block13;
                }
                if (Trace.isOn(64)) {
                    FastStringBuffer buf3 = new FastStringBuffer(120).append("[JCoAPI] JCoServer\tdispatches (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]").append(" after\tgetCallHandler(), factory is ").append(handler == null ? "null" : handler.getClass().getName());
                    Trace.fireTrace(64, buf3.toString());
                }
            }
            if (handler == null) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", new StringBuffer("the call handler factory [").append(this.aFactory.getClass().getName()).append("] returns null\tfor\tthe\tfunction ").append(function.getName()).toString());
            }
            if (Trace.isOn(64)) {
                buf = new StringBuilder(120).append("[JCoAPI]\tJCoServer before dispatch (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]");
                if (Trace.isOn(16)) {
                    Trace.dumpFunction((StringBuilder)buf, Trace.isOn(256), true, false, function);
                }
                Trace.fireTrace(64, ((StringBuilder)buf).toString());
            }
            handler.handleRequest(serverCtx, function);
            if (!Trace.isOn(64)) return handler;
            buf = new StringBuilder(120).append("[JCoAPI]\tJCoServer after\tdispatch (").append(function.getName()).append(") on handle\t[").append(DefaultServerWorker.this.getConnectionHandle()).append("]");
            if (Trace.isOn(16)) {
                Trace.dumpFunction((StringBuilder)buf, false, false, true, function);
            }
            Trace.fireTrace(64, ((StringBuilder)buf).toString());
            return handler;
        }
    }

    public abstract class CallDispatcher {
        private ExtendedCallHandlerFactory extFactory = null;

        protected CallDispatcher(JCoServerCallHandlerFactory factory) {
            if (factory instanceof ExtendedCallHandlerFactory) {
                this.extFactory = (ExtendedCallHandlerFactory)((Object)factory);
            }
        }

        protected abstract Object handleRequest(JCoServerContext var1, JCoFunction var2) throws AbapException, AbapClassException;

        protected JCoFunction getFunction(JCoServerContext serverCtx, String functionName) throws JCoException {
            if (this.extFactory != null) {
                return this.extFactory.getFunction(serverCtx, functionName);
            }
            return DefaultServerWorker.this.server.getRepository(serverCtx).getFunction(functionName);
        }
    }

    final class BgRfcCallContext {
        AbapFunctionUnit.UnitIdentifier unitIdentifier = new AbapFunctionUnit.UnitIdentifier();
        JCoBackgroundUnitAttributes unitAttributes;

        BgRfcCallContext() {
        }
    }

    class ServerContext
    implements JCoServerContext {
        JCoServerCallType callType = null;
        BgRfcCallContext bgRfcCallCtx = new BgRfcCallContext();
        String tid;

        ServerContext() {
        }

        public JCoAttributes getConnectionAttributes() {
            try {
                return DefaultServerWorker.this.conn.getAttributes();
            }
            catch (JCoException e) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] exception in JCoServer.getConnectionAttributes: " + e.toString(), e);
                }
                return null;
            }
        }

        public String getConnectionID() {
            return DefaultServerWorker.this.conn.getConnectionId();
        }

        public JCoRepository getRepository() {
            return DefaultServerWorker.this.server.getRepository(this);
        }

        public JCoServer getServer() {
            return DefaultServerWorker.this.server;
        }

        public String getSessionID() {
            return DefaultServerWorker.this.conn.getSessionId();
        }

        public String getTID() {
            return this.tid;
        }

        public boolean isInTransaction() {
            return this.tid != null || this.bgRfcCallCtx.unitIdentifier.getType() != null;
        }

        public JCoServerCallType getCallType() {
            return this.callType;
        }

        public JCoUnitIdentifier getUnitIdentifier() {
            if (this.bgRfcCallCtx.unitIdentifier.getType() != null) {
                return this.bgRfcCallCtx.unitIdentifier;
            }
            return null;
        }

        public JCoBackgroundUnitAttributes getFunctionUnitAttributes() {
            if (this.getCallType() == JCoServerCallType.BACKGROUND_UNIT) {
                return this.bgRfcCallCtx.unitAttributes;
            }
            return null;
        }

        public boolean isStatefulSession() {
            return this.getSessionID() != null;
        }

        public void setStateful(boolean stateful) {
            String connectionSessionId = DefaultServerWorker.this.conn.getSessionId();
            if (stateful && connectionSessionId == null) {
                String sessionID = null;
                if (DefaultServerWorker.this.sessionRefProvider != null) {
                    try {
                        JCoSessionReference sesRef = DefaultServerWorker.this.sessionRefProvider.getCurrentSessionReference(null);
                        if (sesRef == null) {
                            Trace.fireTraceCritical("[JCoAPI] session reference\tprovider [" + DefaultServerWorker.this.sessionRefProvider.getClass().getName() + "] returns null\tfor\tthe\tcurrent\tsession. Conversation ID will be used instead.");
                        } else {
                            sessionID = sesRef.getID();
                        }
                    }
                    catch (Exception e) {
                        Trace.fireTraceCritical("[JCoAPI] session reference\tprovider [" + DefaultServerWorker.this.sessionRefProvider.getClass().getName() + "] throws exception\ton getID().\tConversation ID\twill be\tused instead.", e);
                    }
                    if (sessionID == null) {
                        sessionID = DefaultServerWorker.this.conn.getConversationID();
                    }
                } else {
                    sessionID = DefaultServerWorker.this.conn.getConversationID();
                }
                DefaultServerWorker.this.conn.setSessionState(stateful, sessionID);
                Context context = DefaultServer.jcoRuntime.getRuntimeContext(sessionID, true);
                context.setServerConnection(DefaultServerWorker.this.conn);
            } else if (!stateful && connectionSessionId != null) {
                Context context = DefaultServer.jcoRuntime.getRuntimeContext(connectionSessionId, false);
                context.setServerConnection(null);
                DefaultServerWorker.this.conn.setSessionState(false, connectionSessionId);
            }
        }
    }

    protected class CallbackHandlerImpl
    implements CallbackHandler {
        protected CallbackHandlerImpl() {
        }

        void checkState() {
            if ((DefaultServerWorker.this.conn.state & 4) == 0) {
                throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "CallbackHandler can be\tused while call\tdispatching\t(JCO.Server.handleRequest()) only.");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(JCoFunction function) throws JCoException {
            int i2;
            boolean isTaskMonitorOn;
            DefaultParameterList outputTables;
            DefaultParameterList inputTables;
            DefaultParameterList output;
            DefaultParameterList changing;
            block41: {
                int i7222;
                this.checkState();
                String name = function.getName();
                DefaultParameterList input = (DefaultParameterList)function.getImportParameterList();
                changing = (DefaultParameterList)function.getChangingParameterList();
                output = (DefaultParameterList)function.getExportParameterList();
                inputTables = (DefaultParameterList)function.getTableParameterList();
                outputTables = (DefaultParameterList)function.getTableParameterList();
                isTaskMonitorOn = DefaultServer.jcoRuntime.isTaskMonitorOn();
                if (isTaskMonitorOn) {
                    StringBuilder monitorText = new StringBuilder();
                    monitorText.append("JCo\texecuting ").append(name).append(" [").append(DefaultServerWorker.this.conn.attributes.sysid).append("|").append(DefaultServerWorker.this.conn.attributes.getPartnerHost()).append("|").append(DefaultServerWorker.this.conn.getConversationID()).append("]");
                    DefaultServer.jcoRuntime.startTask(monitorText.toString());
                }
                if (input != null) {
                    input.checkIfInitialized();
                    for (int i2 = 0; i2 < input.getMetaData().getFieldCount(); ++i2) {
                        if (input.isActive(i2) && input.isInitialized(i2)) continue;
                        int n = i2;
                        input.flags[n] = (byte)(input.flags[n] | 8);
                    }
                }
                if (inputTables != null) {
                    for (int i3 = 0; i3 < inputTables.getMetaData().getFieldCount(); ++i3) {
                        if (inputTables.isActive(i3)) continue;
                        int n = i3;
                        inputTables.flags[n] = (byte)(inputTables.flags[n] | 8);
                    }
                }
                if (changing != null) {
                    changing.checkIfInitialized();
                    for (int i4 = 0; i4 < changing.getMetaData().getFieldCount(); ++i4) {
                        if (changing.isActive(i4) && changing.isInitialized(i4)) continue;
                        int n = i4;
                        changing.flags[n] = (byte)(changing.flags[n] | 8);
                    }
                }
                if (output != null) {
                    for (int i5 = 0; i5 < output.getMetaData().getFieldCount(); ++i5) {
                        if (output.isActive(i5)) continue;
                        int n = i5;
                        output.flags[n] = (byte)(output.flags[n] | 8);
                    }
                }
                if (outputTables != null) {
                    for (int i6 = 0; i6 < outputTables.getMetaData().getFieldCount(); ++i6) {
                        if (outputTables.isActive(i6)) continue;
                        int n = i6;
                        outputTables.flags[n] = (byte)(outputTables.flags[n] | 8);
                    }
                }
                try {
                    try {
                        StringBuilder buf;
                        if (Trace.isOn(128)) {
                            buf = new StringBuilder(120).append("[JCoAPI]\tServerWorker.execute (").append(name).append(")\ton handle [").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("]");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, Trace.isOn(256), true, false, function);
                            }
                            Trace.fireTrace(128, buf.toString());
                        }
                        DefaultServerWorker.this.conn.middlewareServer.execute(DefaultServerWorker.this, name, input, inputTables, changing, output, function.getFunctionTemplate().supportsASXML(), ((AbapFunction)function).getAbapClassExceptionMode());
                        if (Trace.isOn(128)) {
                            buf = new StringBuilder(200).append("[JCoAPI]\tServerWorker.execute (").append(name);
                            buf.append(") on handle\t[").append(DefaultServerWorker.this.conn.getConnectionHandle()).append("] returns ");
                            if (Trace.isOn(16)) {
                                Trace.dumpFunction(buf, false, false, true, function);
                            }
                            Trace.fireTrace(128, buf.toString());
                        }
                    }
                    catch (AbapException ex) {
                        if (!Trace.isOn(64)) throw ex;
                        Trace.fireTrace(64, new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") threw an\tABAP exception:\t").append(ex.toString()).toString());
                        throw ex;
                    }
                    catch (JCoException ex) {
                        if (!Trace.isOn(4)) throw ex;
                        Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") threw a NON-ABAP\texception: ").append(ex.toString()).toString());
                        Trace.fireTrace(32, "[JCoAPI] ServerWorker.execute\tthrew a\tNON-ABAP exception", ex);
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (!Trace.isOn(4)) throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                        Trace.fireTrace(4, new FastStringBuffer(120).append("[JCoAPI] ServerWorker.execute (").append(name).append(") threw a NON-ABAP\texception: ").append(ex.toString()).toString());
                        Trace.fireTrace(32, "[JCoAPI] ServerWorker.execute\tthrew a\tNON-ABAP exception", ex);
                        throw new JCoException(108, "JCO_ERROR_INTERNAL", ex.toString(), ex);
                    }
                    Object var11_18 = null;
                    if (input == null) break block41;
                    i7222 = 0;
                }
                catch (Throwable throwable) {
                    int i2;
                    Object var11_19 = null;
                    if (input != null) {
                        int i7222 = 0;
                        while (i7222 < input.getMetaData().getFieldCount()) {
                            int n = i7222++;
                            input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (inputTables != null) {
                        int i22 = 0;
                        while (i22 < inputTables.getMetaData().getFieldCount()) {
                            int n = i22++;
                            inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (changing != null) {
                        int i22 = 0;
                        while (i22 < changing.getMetaData().getFieldCount()) {
                            int n = i22++;
                            changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (output != null) {
                        i2 = 0;
                        while (i2 < output.getMetaData().getFieldCount()) {
                            int n = i2++;
                            output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (outputTables != null) {
                        i2 = 0;
                        while (i2 < outputTables.getMetaData().getFieldCount()) {
                            int n = i2++;
                            outputTables.flags[n] = (byte)(outputTables.flags[n] & 0xFFFFFFF7);
                        }
                    }
                    if (!isTaskMonitorOn) throw throwable;
                    DefaultServer.jcoRuntime.endTask();
                    throw throwable;
                }
                while (i7222 < input.getMetaData().getFieldCount()) {
                    int n = i7222++;
                    input.flags[n] = (byte)(input.flags[n] & 0xFFFFFFF7);
                }
            }
            if (inputTables != null) {
                int i22 = 0;
                while (i22 < inputTables.getMetaData().getFieldCount()) {
                    int n = i22++;
                    inputTables.flags[n] = (byte)(inputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (changing != null) {
                int i22 = 0;
                while (i22 < changing.getMetaData().getFieldCount()) {
                    int n = i22++;
                    changing.flags[n] = (byte)(changing.flags[n] & 0xFFFFFFF7);
                }
            }
            if (output != null) {
                i2 = 0;
                while (i2 < output.getMetaData().getFieldCount()) {
                    int n = i2++;
                    output.flags[n] = (byte)(output.flags[n] & 0xFFFFFFF7);
                }
            }
            if (outputTables != null) {
                i2 = 0;
                while (i2 < outputTables.getMetaData().getFieldCount()) {
                    int n = i2++;
                    outputTables.flags[n] = (byte)(outputTables.flags[n] & 0xFFFFFFF7);
                }
            }
            if (!isTaskMonitorOn) return;
            DefaultServer.jcoRuntime.endTask();
        }

        public JCoResponse execute(JCoRequest request) throws JCoException {
            if (request == null) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "request is null");
            }
            try {
                this.execute(((DefaultRequest)request).function);
                return ((DefaultRequest)request).getResponse();
            }
            catch (ClassCastException e) {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unexpected type detected\t" + request.getClass().getName());
            }
        }

        public JCoFunction getFunction(String functionName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getFunction(functionName);
        }

        public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
            return DefaultServerWorker.this.conn.serverGroup.getRepository().getStructureDefinition(structureName);
        }
    }
}

