/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerStatus;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteSkybotServerDM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class RemoteSkybotServerDMJdbc
extends AbstractDatabaseManager
implements RemoteSkybotServerDM {
    private static final Logger logger = Logger.getLogger(RemoteSkybotServerDMJdbc.class);
    private static final String REMOTE_SERVERS_TABLE = "remote_servers";
    private static final String REMOTE_SKYBOT_SERVERS_TABLE = "remote_automate_servers";
    private String remoteServersTable;
    private String remoteSkybotServersTable;

    public RemoteSkybotServerDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string3);
        this.remoteServersTable = string2 + "." + REMOTE_SERVERS_TABLE;
        this.remoteSkybotServersTable = string2 + "." + REMOTE_SKYBOT_SERVERS_TABLE;
        this.setName(string3);
    }

    public long register(long l, long l2, String string) throws RemoteServerException {
        long l3;
        try {
            l3 = this.createRemoteServerTableEntries(l, l2, string);
        }
        catch (Exception exception) {
            throw new RemoteServerException("Registration failed.", (Throwable)exception);
        }
        return l3;
    }

    private String createDescription(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        return "Registered " + simpleDateFormat.format(new Date(l));
    }

    private long createRemoteServerTableEntries(long l, long l2, String string) {
        boolean bl = false;
        long l3 = 0L;
        try {
            l3 = this.createRemoteServerTableEntry(string, l2);
            bl = true;
            this.createRemoteSkybotServerTableEntry(l3, l, l2);
        }
        catch (Exception exception) {
            if (bl) {
                try {
                    this.deleteRemoteServerTableEntry(l3);
                }
                catch (Exception exception2) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to delete the remote server row with id={0}, just created.", (Object[])new Object[]{l3}), (Throwable)exception2);
                }
            }
            throw new IllegalStateException("Unable to create the remote server table entries", exception);
        }
        return l3;
    }

    private long createRemoteServerTableEntry(String string, long l) throws NotSavedException, ResourceUnavailableException {
        String string2 = "INSERT INTO " + this.remoteServersTable + " (name, description, server_type) " + "VALUES(?,?,?)";
        PreparedStatement preparedStatement = this.getPreparedStmtThatReturnsGeneratedKeys(string2, null);
        try {
            preparedStatement.setString(1, this.makeUnique(string));
            preparedStatement.setString(2, this.createDescription(l));
            preparedStatement.setInt(3, RemoteServerType.SKYBOT.persistanceCode());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("Unable to create the remote server table entry.");
            }
            long l2 = this.retrieveGeneratedKey(preparedStatement);
            return l2;
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while creating the remote server table entry.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void createRemoteSkybotServerTableEntry(long l, long l2, long l3) throws NotSavedException, ResourceUnavailableException {
        String string = "INSERT INTO " + this.remoteSkybotServersTable + " (remote_server_id, assigned_remote_id, registered_utc, status, created_by_remote_server) " + "VALUES(?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            preparedStatement.setInt(4, RemoteServerStatus.APPROVAL_REQUIRED.persistanceCode());
            preparedStatement.setBoolean(5, true);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("Unable to create the remote Automate server table entry.");
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while creating the remote Automate server table entry.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void deleteRemoteServerTableEntry(long l) throws ResourceUnavailableException {
        String string = "DELETE FROM " + this.remoteServersTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error deleting the remote server table entry with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private boolean isInDatabase(String string) throws ResourceUnavailableException {
        String string2 = "SELECT COUNT(*) FROM " + this.remoteServersTable + " WHERE name=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while trying to check if server name {0} already exists in the database.", (Object[])new Object[]{string});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String makeUnique(String string) throws ResourceUnavailableException {
        String string2;
        if (!this.isInDatabase(string)) {
            return string;
        }
        int n = 1;
        while (this.isInDatabase(string2 = string + "_" + n++)) {
        }
        return string2;
    }
}

