/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.UnknownEnumException;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEventHistory;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventHistoryDM;
import com.helpsystems.enterprise.core.remoteserver.RBTNotification;
import com.helpsystems.enterprise.core.remoteserver.RegisteredServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification_TL;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventSource;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteObject;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerNotConfiguredException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteSkybotServer;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteServerDMSkybotImpl
extends AbstractDatabaseManager
implements RemoteServerDM {
    private static final Logger logger = Logger.getLogger(RemoteServerDMSkybotImpl.class);
    private static final String JOBS_TABLE = "jobs";
    private static final String JOB_SUITE_MEMBER_JOBS_TABLE = "job_suite_member_jobs";
    private static final String MEMBER_JOBS_TABLE = "job_suite_member_jobs";
    private static final String AGENT_EVENTS_TABLE = "agent_event_monitors";
    private String jobsTable;
    private String jobSuiteMemberJobsTable;
    private String memberJobsTable;
    private String agentEventsTable;
    private RemoteServersDM remoteServersDM;
    private RemoteDependencyDM remoteDependencyDM;
    private RemoteEventHistoryDM remoteEventHistoryDM;
    private RemoteEventDM remoteEventDM;
    private ReactivityAM reactivityAM;

    public RemoteServerDMSkybotImpl(String string, String string2, String string3, RemoteServersDM remoteServersDM, RemoteDependencyDM remoteDependencyDM, RemoteEventHistoryDM remoteEventHistoryDM, RemoteEventDM remoteEventDM) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"RemoteServersDM", (Object)remoteServersDM);
        ValidationHelper.checkForNull((String)"RemoteDependencyDM", (Object)remoteDependencyDM);
        ValidationHelper.checkForNull((String)"RemoteEventHistoryDM", (Object)remoteEventHistoryDM);
        ValidationHelper.checkForNull((String)"RemoteEventDM", (Object)remoteEventDM);
        this.setName(string3);
        this.jobsTable = string2 + "." + JOBS_TABLE;
        this.jobSuiteMemberJobsTable = string2 + "." + "job_suite_member_jobs";
        this.memberJobsTable = string2 + "." + "job_suite_member_jobs";
        this.agentEventsTable = string2 + "." + AGENT_EVENTS_TABLE;
        this.remoteServersDM = remoteServersDM;
        this.remoteDependencyDM = remoteDependencyDM;
        this.remoteEventHistoryDM = remoteEventHistoryDM;
        this.remoteEventDM = remoteEventDM;
    }

    public boolean areYouThere() {
        return true;
    }

    public int[] getNotifiableEventTypes() throws RemoteServerException {
        int n = RemoteEventType.JOB_STATUS_CHANGE.persistanceCode();
        int n2 = RemoteEventType.JOB_SUITE_STATUS_CHANGE.persistanceCode();
        int n3 = RemoteEventType.JOB_SUITE_MEMBER_STATUS_CHANGE.persistanceCode();
        int n4 = RemoteEventType.AGENT_EVENT.persistanceCode();
        int n5 = RemoteEventType.JOB_MONITOR_EVENT.persistanceCode();
        int n6 = RemoteEventType.JOB_SUITE_MONITOR_EVENT.persistanceCode();
        int n7 = RemoteEventType.JOB_SUITE_MEMBER_MONITOR_EVENT.persistanceCode();
        return new int[]{n, n2, n3, n4, n5, n6, n7};
    }

    public String[] getNotifiableEventStatuses(RemoteEventType remoteEventType) throws RemoteServerException {
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        String string = PrereqStatusType.SUBMITTED.persistanceCode();
        String string2 = PrereqStatusType.RUNNING.persistanceCode();
        String string3 = PrereqStatusType.COMPLETED.persistanceCode();
        String string4 = PrereqStatusType.FAILED.persistanceCode();
        String string5 = PrereqStatusType.CANCELED.persistanceCode();
        String string6 = PrereqStatusType.CONDITION_RETRY_WAIT.persistanceCode();
        String string7 = PrereqStatusType.SKIPPED.persistanceCode();
        String string8 = PrereqStatusType.ENDED.persistanceCode();
        String string9 = PrereqStatusType.OCCURRED.persistanceCode();
        String string10 = PrereqStatusType.LATE_START.persistanceCode();
        String string11 = PrereqStatusType.OVER_RUN.persistanceCode();
        String string12 = PrereqStatusType.UNDER_RUN.persistanceCode();
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return new String[]{string3, string4, string8, string5, string2, string, string7, string6};
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return new String[]{string3, string4, string8, string5, string2, string7};
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return new String[]{string3, string4, string8, string5, string2, string, string7, string6};
            }
            case AGENT_EVENT: {
                return new String[]{string9};
            }
            case JOB_MONITOR_EVENT: 
            case JOB_SUITE_MONITOR_EVENT: 
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return new String[]{string10, string11, string12};
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getEvents(RemoteEventType remoteEventType) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        return this.getEvents(remoteEventType, null, 0, 0);
    }

    public RemoteObject[] getEvents(RemoteEventType remoteEventType, String string, int n, int n2) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        String string2;
        this.validateRemoteEventType(remoteEventType);
        if (string.contains("'")) {
            string = null;
        }
        String string3 = " (late_start_monitor_selected = true OR overrun_monitor_selected = true OR underrun_monitor_selected = true)";
        String string4 = "";
        if (string != null && !string.trim().isEmpty()) {
            string4 = MessageUtil.formatMsg((String)" name ILIKE ''{0}%''", (Object[])new Object[]{string.trim()});
        }
        String string5 = "";
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                string5 = MessageUtil.formatMsg((String)" job_type={0}", (Object[])new Object[]{JobType.JOB.persistanceCode()});
                string2 = this.jobsTable;
                break;
            }
            case JOB_SUITE_STATUS_CHANGE: {
                string5 = MessageUtil.formatMsg((String)" job_type={0}", (Object[])new Object[]{JobType.SUITE.persistanceCode()});
                string2 = this.jobsTable;
                break;
            }
            case AGENT_EVENT: {
                string2 = this.agentEventsTable;
                break;
            }
            case JOB_MONITOR_EVENT: {
                string5 = MessageUtil.formatMsg((String)" job_type={0} AND", (Object[])new Object[]{JobType.JOB.persistanceCode()}) + string3;
                string2 = this.jobsTable;
                break;
            }
            case JOB_SUITE_MONITOR_EVENT: {
                string5 = MessageUtil.formatMsg((String)" job_type={0} AND", (Object[])new Object[]{JobType.SUITE.persistanceCode()}) + string3;
                string2 = this.jobsTable;
                break;
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                string5 = MessageUtil.formatMsg((String)" job_type={0} AND", (Object[])new Object[]{JobType.SUITE_MEMBER.persistanceCode()}) + string3;
                string2 = this.jobsTable;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
            }
        }
        String string6 = this.rangeRestriction(n, n2, "t.row_id");
        return this.getEvents(string2, string4, string5, string6, this.toEventType_forMessageString(remoteEventType));
    }

    public RemoteObject[] getSuiteMembers(long l) throws ResourceUnavailableException {
        return this.getSuiteMembers(l, null, 0, 0);
    }

    public RemoteObject[] getSuiteMembers(long l, String string, int n, int n2) throws ResourceUnavailableException {
        ArrayList<RemoteObject> arrayList = new ArrayList<RemoteObject>();
        try {
            this.validateObject(RemoteEventType.JOB_SUITE_STATUS_CHANGE, l);
            String string2 = "";
            if (string != null && !string.trim().isEmpty()) {
                string2 = MessageUtil.formatMsg((String)" AND name ILIKE ''{0}%''", (Object[])new Object[]{string.trim()});
            }
            String string3 = this.rangeRestriction(n, n2, "row_id");
            String string4 = "WITH members AS (select row_number() over(order by name) as row_id, m.id AS member_id, name, description from " + this.memberJobsTable + " m join " + this.jobsTable + " j on member_job_id = j.id " + "WHERE job_suite_id =?" + string2 + ") " + "SELECT member_id, name, description FROM members" + string3;
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string4);
            try {
                preparedStatement.setLong(1, l);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    long l2 = resultSet.getLong("member_id");
                    String string5 = Convert.trimR((String)resultSet.getString("name"));
                    String string6 = Convert.trimR((String)resultSet.getString("description"));
                    arrayList.add(new RemoteObject((Object)l2, string5, string6));
                }
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("SQL error while retrieving the member list on the remote server.", (Throwable)sQLException);
            }
            finally {
                this.closeConnection(preparedStatement);
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to get the members for a suite.", exception);
        }
        return arrayList.toArray(new RemoteObject[arrayList.size()]);
    }

    public boolean isObjectExists(RemoteEventType remoteEventType, long l) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        throw new IllegalStateException("Program error: This version of the isObjectExists method should not be called on a Skybot type remote server.");
    }

    public boolean isObjectExists(int n, long l, long l2) throws RemoteServerException {
        try {
            this.validateRequestingServer(l2);
            RemoteEventType remoteEventType = RemoteEventType.persistanceCodeToEnum((int)n);
            return this.isInDatabase(remoteEventType, l);
        }
        catch (Exception exception) {
            throw new RemoteServerException("Unable to check if an object exists in the database.", (Throwable)exception);
        }
    }

    public void notifyOfDependency(RemoteEventType remoteEventType, long l) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        throw new IllegalStateException("Program error: This version of the notifyOfDependency method should not be called on a Skybot type remote server.");
    }

    public void notifyOfDependency(int n, long l, long l2) throws RemoteServerException {
        try {
            RemoteSkybotServer remoteSkybotServer = this.validateRequestingServer(l2);
            RemoteEventType remoteEventType = RemoteEventType.persistanceCodeToEnum((int)n);
            this.validateObject(remoteEventType, l);
            long l3 = remoteSkybotServer.getId();
            if (!this.isDependencyAlreadyExists(remoteEventType, l, l3)) {
                this.remoteDependencyDM.createRemoteDependency(remoteEventType, l, l3);
            }
        }
        catch (Exception exception) {
            throw new RemoteServerException("Unable to create a remote dependency entry.", (Throwable)exception);
        }
    }

    public long notifyOfEvent(RemoteDependencyNotification remoteDependencyNotification) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the notifyOfEvent method should not be called on a Skybot type remote server.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long notifyOfEvent(RemoteDependencyNotification_TL remoteDependencyNotification_TL, long l) throws RemoteServerException, UnknownEnumException {
        Object object;
        Object object2;
        RemoteEvent remoteEvent;
        Object object3;
        RemoteDependencyNotification remoteDependencyNotification;
        ValidationHelper.checkForNull((String)"Remote Dependency Notification", (Object)remoteDependencyNotification_TL);
        long l2 = this.retrieveTheServerIDForThisRegisteredDateTime(l);
        try {
            remoteDependencyNotification = RemoteDependencyNotification.fromRemoteDependencyNotification_TL((RemoteDependencyNotification_TL)remoteDependencyNotification_TL);
        }
        catch (UnknownEnumException unknownEnumException) {
            try {
                logger.info((Object)MessageUtil.formatMsg((String)"This server has been notified of an event from remote server {0}. However, some data in that event was not recognized, so the event was not processed. Most likely this is because the other server is at a higher version level. Details: {1}", (Object[])new Object[]{this.remoteServerName(l2), unknownEnumException.getMessage()}));
                throw unknownEnumException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw unknownEnumException;
        }
        long l3 = 0L;
        try {
            try {
                long l4 = remoteDependencyNotification.getObjectID();
                PrereqEventType prereqEventType = remoteDependencyNotification.getEventType();
                object3 = this.toRemoteEventType(prereqEventType);
                remoteEvent = this.remoteEventDM.get(l2, l4, object3);
            }
            catch (NoDataException noDataException) {
                try {
                    logger.warn((Object)MessageUtil.formatMsg((String)"This server has been notified of event {0} from remote server {1}. However, there is no entry in the remote_events table that matches the notification event. The remote server has been informed that this notification has been refused.", (Object[])new Object[]{remoteDependencyNotification, this.remoteServerName(l2)}));
                    return -1L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return -1L;
            }
            object2 = this.createRemoteEventHistory(remoteEvent, remoteDependencyNotification);
            try {
                long l5 = remoteDependencyNotification.getNotificationHistoryID();
                long l6 = remoteDependencyNotification.getStatusTimestamp();
                AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
                try {
                    if (this.weHaveAlreadyBeenNotifiedOfThisEvent(l2, l5, l6, (Connection)wrappedConnection)) {
                        l3 = this.remoteEventHistoryDM.getID(l2, l5, l6, (Connection)wrappedConnection);
                        try {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
                            logger.warn((Object)MessageUtil.formatMsg((String)"This server has been notified of event {0} from remote server {1}. However, it appears that the event has already been processed, since the remote event history entry with ID {2} appears to match the incoming event. The match is based on three fields - remote server ID {3}, remote notification history ID {4}, and remote server time {5}. The event will not be processed again. The ID of the existing remote history entry ({2}) will be returned to the sending remote server as proof of receipt by this server.", (Object[])new Object[]{remoteDependencyNotification, this.remoteServerName(l2), l3, l2, l5, simpleDateFormat.format(l6)}));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        long l7 = l3;
                        return l7;
                    }
                    object = this.remoteEventHistoryDM.save(object2, (Connection)wrappedConnection);
                    l3 = object.getId();
                }
                finally {
                    RemoteServerDMSkybotImpl.closeEm((Connection)wrappedConnection, null, null);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to save the remote server event notification to the remote event history database table.", exception);
            }
            this.reactivityAM().notifyRemoteEvent(object);
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Unable to process the notification event ({0}) from remote server {1}.", (Object[])new Object[]{remoteDependencyNotification, this.remoteServerName(l2)}), (Throwable)exception);
        }
        object2 = this.trimmed(remoteEvent.getRemoteObjectName());
        object = this.trimmed(remoteDependencyNotification.getObjectName());
        this.updateNameIfChanged((String)object2, (String)object, remoteEvent);
        if (remoteEvent.getEventType() != RemoteEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) return l3;
        String string = this.trimmed(remoteEvent.getJobSuiteName());
        object3 = this.trimmed(remoteDependencyNotification.getJobSuiteName());
        this.updateSuiteNameIfChanged(string, (String)object3, remoteEvent);
        return l3;
    }

    public int removeDependency(int n, long l, long l2) throws RemoteServerException {
        long l3 = this.retrieveTheServerIDForThisRegisteredDateTime(l2);
        try {
            RemoteEventType remoteEventType = RemoteEventType.persistanceCodeToEnum((int)n);
            int n2 = this.remoteDependencyDM.deleteRemoteDependency(remoteEventType, l, l3);
            return n2;
        }
        catch (Exception exception) {
            try {
                throw new IllegalStateException("Error while trying to delete the dependency entry.", exception);
            }
            catch (Exception exception2) {
                String string = this.toEventType_forMessageString(n);
                throw new RemoteServerException(MessageUtil.formatMsg((String)"Unable to remove the dependency entry for the {0} with ID {1} from remote server {2}.", (Object[])new Object[]{string, l, this.remoteServerName(l3)}), (Throwable)exception2);
            }
        }
    }

    public int removeDependency(long l, RemoteEventType remoteEventType, long l2) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        throw new IllegalStateException("Program error: This version of the removeDependency method should not be called on a Skybot type remote server.");
    }

    private RemoteEventHistory createRemoteEventHistory(RemoteEvent remoteEvent, RemoteDependencyNotification remoteDependencyNotification) {
        RemoteEventHistory remoteEventHistory = new RemoteEventHistory();
        remoteEventHistory.setRemoteEventID(remoteEvent.getId());
        remoteEventHistory.setRemoteServerID(remoteEvent.getRemoteServerID());
        remoteEventHistory.setType(remoteEvent.getEventType());
        remoteEventHistory.setObjectID(remoteDependencyNotification.getObjectID());
        remoteEventHistory.setObjectName(remoteDependencyNotification.getObjectName());
        remoteEventHistory.setStatus(remoteDependencyNotification.getEventStatus());
        remoteEventHistory.setRemoteSystemTime(remoteDependencyNotification.getStatusTimestamp());
        remoteEventHistory.setSourceKey(remoteDependencyNotification.getEventSourceID());
        remoteEventHistory.setSourceName(remoteDependencyNotification.getEventSourceInfo());
        remoteEventHistory.setRemoteNotificationHistoryID(remoteDependencyNotification.getNotificationHistoryID());
        if (remoteDependencyNotification.getEventType() == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) {
            remoteEventHistory.setJobSuiteID(remoteDependencyNotification.getJobSuiteID());
            remoteEventHistory.setJobSuiteName(remoteDependencyNotification.getJobSuiteName());
        }
        remoteEventHistory.setServerTime(System.currentTimeMillis());
        remoteEventHistory.setSource(RemoteEventSource.REMOTE_SERVER);
        return remoteEventHistory;
    }

    private RemoteObject[] getEvents(String string, String string2, String string3, String string4, String string5) throws ResourceUnavailableException {
        ArrayList<RemoteObject> arrayList = new ArrayList<RemoteObject>();
        if (!string2.isEmpty()) {
            string2 = " WHERE" + string2;
        } else if (!string3.isEmpty()) {
            string3 = " WHERE" + string3;
        }
        if (!string2.isEmpty() && !string3.isEmpty()) {
            string2 = string2 + " AND";
        }
        String string6 = "SELECT id, name, description FROM (SELECT ROW_NUMBER() OVER(ORDER BY name) AS row_id, id, name, description FROM " + string + string2 + string3 + ") t " + string4;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string6);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong("id");
                String string7 = Convert.trimR((String)resultSet.getString("name"));
                String string8 = Convert.trimR((String)resultSet.getString("description"));
                arrayList.add(new RemoteObject((Object)l, string7, string8));
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"SQL error while retrieving the {0} list on the remote server.", (Object[])new Object[]{string5}), (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new RemoteObject[arrayList.size()]);
    }

    private boolean isDependencyAlreadyExists(RemoteEventType remoteEventType, long l, long l2) throws RemoteServerException {
        try {
            return this.remoteDependencyDM.isInDatabase(remoteEventType, l, l2);
        }
        catch (Exception exception) {
            throw new RemoteServerException("Unable to determine if the remote dependency entry already exists.", (Throwable)exception);
        }
    }

    private boolean isInArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private boolean isInDatabase(RemoteEventType remoteEventType, long l) throws ResourceUnavailableException {
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: 
            case JOB_SUITE_STATUS_CHANGE: {
                return this.isInDatabase(this.jobsTable, l);
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return this.isInDatabase(this.jobSuiteMemberJobsTable, l);
            }
            case AGENT_EVENT: {
                return this.isInDatabase(this.agentEventsTable, l);
            }
            case JOB_MONITOR_EVENT: 
            case JOB_SUITE_MONITOR_EVENT: 
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                logger.warn((Object)MessageUtil.formatMsg((String)"Unable to verify that the {0} with ID {1} exists in the database. The assumption will be that it does exist.", (Object[])new Object[]{this.toEventType_forMessageString(remoteEventType), l}));
                return true;
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    private boolean isInDatabase(String string, long l) throws ResourceUnavailableException {
        String string2 = "SELECT COUNT(*) FROM " + string + " WHERE id=?";
        Object[] objectArray = new Object[]{new Long(l)};
        try {
            return this.doCount(string2, objectArray) > 0;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error while checking if an object with ID {0} exists in database table {1}.", (Object[])new Object[]{l, string}), (Throwable)exception);
        }
    }

    private String toEventType_forMessageString(RemoteEventType remoteEventType) {
        if (remoteEventType == null) {
            return "null";
        }
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return "Job";
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return "Job Suite";
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return "Job Suite Member";
            }
            case AGENT_EVENT: {
                return "Agent Event";
            }
            case SNMP_TRAP_EVENT: {
                return "SNMP Trap Event";
            }
            case JOB_MONITOR_EVENT: {
                return "Job Monitor Event";
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return "Job Suite Monitor Event";
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return "Job Suite Member Monitor Event";
            }
            case SAP_MONITOR_EVENT: {
                return "SAP Monitor Event";
            }
        }
        return remoteEventType.toString();
    }

    private String toEventType_forMessageString(int n) {
        try {
            RemoteEventType remoteEventType = RemoteEventType.persistanceCodeToEnum((int)n);
            return this.toEventType_forMessageString(remoteEventType);
        }
        catch (Exception exception) {
            return MessageUtil.formatMsg((String)"Remote Event Type code {0}", (Object[])new Object[]{n});
        }
    }

    private RemoteEventType toRemoteEventType(PrereqEventType prereqEventType) {
        return RemoteEventType.persistanceCodeToEnum((int)prereqEventType.persistanceCode());
    }

    private String toString(RemoteEvent remoteEvent) {
        if (remoteEvent != null) {
            String string = this.remoteServersDM.getServerName(remoteEvent.getRemoteServerID());
            return MessageUtil.formatMsg((String)"{0} for the object {1} on remote server {2}", (Object[])new Object[]{remoteEvent.getEventType(), remoteEvent.getRemoteObjectName(), string});
        }
        return "";
    }

    private String rangeRestriction(int n, int n2, String string) {
        String string2 = "";
        if (n > 0) {
            string2 = " WHERE {0} >= {1} AND {0} <= {2}";
        } else if (n2 > 0) {
            string2 = " WHERE {0} >= {1}";
        }
        return MessageUtil.formatMsg((String)string2, (Object[])new Object[]{string, n2 + 1, n2 + n});
    }

    private ReactivityAM reactivityAM() {
        if (this.reactivityAM == null) {
            this.reactivityAM = (ReactivityAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReactivityAM");
        }
        return this.reactivityAM;
    }

    private String remoteServerName(long l) {
        return this.remoteServersDM.getServerName(l);
    }

    private long retrieveTheServerIDForThisRegisteredDateTime(long l) throws RemoteServerException {
        try {
            return this.remoteServersDM.getServerID(l, RemoteServerType.SKYBOT);
        }
        catch (NoDataException noDataException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Unable to identify the requesting remote server. {0}", (Object[])new Object[]{noDataException.getMessage()}));
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error trying to identify the remote server with registered date/time = {0}.", (Object[])new Object[]{l}), (Throwable)exception);
        }
    }

    private String trimmed(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private void updateNameIfChanged(String string, String string2, RemoteEvent remoteEvent) {
        try {
            if (!string2.isEmpty() && !string2.equals(string)) {
                logger.info((Object)MessageUtil.formatMsg((String)"Detected a name change for the object associated with remote event {0}. {1} --> {2}. The remote_events table will be updated.", (Object[])new Object[]{this.toString(remoteEvent), string, string2}));
                this.remoteEventDM.updateObjectName(remoteEvent.getId(), string2);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error updating the name of the object associated with remote event {0}.", (Object[])new Object[]{this.toString(remoteEvent)}), (Throwable)exception);
        }
    }

    private void updateSuiteNameIfChanged(String string, String string2, RemoteEvent remoteEvent) {
        try {
            if (!string2.isEmpty() && !string2.equals(string)) {
                logger.info((Object)MessageUtil.formatMsg((String)"Detected a job suite name change associated with remote event {0}. {1} --> {2}. The remote_events table will be updated.", (Object[])new Object[]{this.toString(remoteEvent), string, string2}));
                this.remoteEventDM.updateSuiteName(remoteEvent.getId(), string2);
            }
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error updating the job suite name associated with remote event {0}.", (Object[])new Object[]{this.toString(remoteEvent)}), (Throwable)exception);
        }
    }

    private void validateRemoteEventType(RemoteEventType remoteEventType) {
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        try {
            if (!this.isInArray(this.getNotifiableEventTypes(), remoteEventType.persistanceCode())) {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this remote server.", (Object[])new Object[]{remoteEventType}));
            }
        }
        catch (RemoteServerException remoteServerException) {
            // empty catch block
        }
    }

    private RemoteSkybotServer validateRequestingServer(long l) throws RemoteServerException {
        RemoteSkybotServer remoteSkybotServer;
        long l2 = this.retrieveTheServerIDForThisRegisteredDateTime(l);
        try {
            remoteSkybotServer = (RemoteSkybotServer)this.remoteServersDM.getServer(l2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while trying to retrieve the information for the remote server with ID {0} from the database.", (Object[])new Object[]{l2}), (Throwable)resourceUnavailableException);
        }
        if (!remoteSkybotServer.isActive()) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"An attempt was made to execute an action on a remote server that is not in an active status. Actual status is {0}.", (Object[])new Object[]{remoteSkybotServer.getStatus()}));
        }
        return remoteSkybotServer;
    }

    private void validateObject(RemoteEventType remoteEventType, long l) throws RemoteServerException {
        boolean bl;
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        try {
            bl = this.isInDatabase(remoteEventType, l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while trying to determine if the {0} with ID {1} exists in the database.", (Object[])new Object[]{this.toEventType_forMessageString(remoteEventType), l}), (Throwable)resourceUnavailableException);
        }
        if (!bl) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"The {0} with ID {1} does not exist in the database.", (Object[])new Object[]{this.toEventType_forMessageString(remoteEventType), l}));
        }
    }

    private boolean weHaveAlreadyBeenNotifiedOfThisEvent(long l, long l2, long l3, Connection connection) throws ResourceUnavailableException {
        return this.remoteEventHistoryDM.isInDatabase(l, l2, connection) && this.remoteEventHistoryDM.isInDatabase(l, l2, l3, connection);
    }

    public List<RBTNotification> getNotificationList(long l, int n) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        logger.warn((Object)"The getNotificationList method is not supported for a Skybot type remote server.");
        return null;
    }

    public void removeNotificationById(long l) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        logger.warn((Object)"The removeNotificationById method is not supported for a Skybot type remote server.");
    }

    public RegisteredServer[] getRegisteredServers(RemoteServer remoteServer) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        logger.warn((Object)"The getRegisteredServers method is not supported for a Skybot type remote server.");
        return null;
    }
}

