/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.remoteserver.RBTNotification;
import com.helpsystems.enterprise.core.remoteserver.RegisteredServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification_TL;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteObject;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerNotConfiguredException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteServerDMScheduleImplSimulator
extends AbstractManager
implements RemoteServerDM {
    private static final Logger logger = Logger.getLogger(RemoteServerDMScheduleImplSimulator.class);
    private long remoteServerID;
    private RemoteServersDM remoteServersDM;

    public RemoteServerDMScheduleImplSimulator(long l, String string) {
        this.setName("ENTERPRISE.RemoteServerDM", string);
        this.remoteServerID = l;
        this.remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");
    }

    public boolean areYouThere() {
        return true;
    }

    public int[] getNotifiableEventTypes() {
        int n = RemoteEventType.JOB_STATUS_CHANGE.persistanceCode();
        int n2 = RemoteEventType.GROUP_JOB_STATUS_CHANGE.persistanceCode();
        return new int[]{n, n2};
    }

    public String[] getNotifiableEventStatuses(RemoteEventType remoteEventType) {
        this.validateRemoteEventType(remoteEventType);
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: 
            case GROUP_JOB_STATUS_CHANGE: {
                String string = PrereqStatusType.SUBMITTED.persistanceCode();
                String string2 = PrereqStatusType.RUNNING.persistanceCode();
                String string3 = PrereqStatusType.FAILED.persistanceCode();
                String string4 = PrereqStatusType.COMPLETED.persistanceCode();
                String string5 = PrereqStatusType.CANCELED.persistanceCode();
                String string6 = PrereqStatusType.SKIPPED.persistanceCode();
                String string7 = PrereqStatusType.ENDED.persistanceCode();
                return new String[]{string, string2, string3, string4, string5, string6, string7};
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getEvents(RemoteEventType remoteEventType) throws RemoteServerNotConfiguredException, ResourceUnavailableException {
        this.validateRemoteEventType(remoteEventType);
        this.validateInstall();
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return this.getJobs();
            }
            case GROUP_JOB_STATUS_CHANGE: {
                return this.getGroupJobs();
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getEvents(RemoteEventType remoteEventType, String string, int n, int n2) throws RemoteServerNotConfiguredException, ResourceUnavailableException {
        logger.info((Object)("Getting Events: startingWith=" + string + " limit=" + n + " start=" + n2));
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return this.getJobs(string, n, n2);
            }
            case GROUP_JOB_STATUS_CHANGE: {
                return this.getGroupJobs(string, n, n2);
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getSuiteMembers(long l) throws ResourceUnavailableException {
        logger.warn((Object)"The getSuiteMembers method is not supported for a SCHEDULE type remote server.");
        return new RemoteObject[0];
    }

    public RemoteObject[] getSuiteMembers(long l, String string, int n, int n2) throws ResourceUnavailableException {
        logger.warn((Object)"The getSuiteMembers method is not supported for a SCHEDULE type remote server.");
        return new RemoteObject[0];
    }

    public boolean isObjectExists(RemoteEventType remoteEventType, long l) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)" =============== Remote Server Simulator.isObjectExists: ");
        logger.warn((Object)" ===============================================================================================");
        return true;
    }

    public boolean isObjectExists(int n, long l, long l2) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the isObjectExists method should not be called on a Schedule type remote server.");
    }

    public void testAccess() throws Exception {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)" =============== Remote Server Simulator.testAccess: ");
        logger.warn((Object)" ===============================================================================================");
    }

    public void notifyOfDependency(RemoteEventType remoteEventType, long l) throws RemoteServerNotConfiguredException, ResourceUnavailableException {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)(" =============== Remote Server Simulator.notifyOfDependency: " + remoteEventType + "/" + l));
        logger.warn((Object)" ===============================================================================================");
    }

    public void notifyOfDependency(int n, long l, long l2) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the notifyOfDependency method should not be called on a Schedule type remote server.");
    }

    public long notifyOfEvent(RemoteDependencyNotification remoteDependencyNotification) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException, ResourceUnavailableException {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)(" =============== Remote Server Simulator.notifyOfEvent: " + remoteDependencyNotification.getObjectName() + " " + remoteDependencyNotification.getEventStatus()));
        logger.warn((Object)" ===============================================================================================");
        return 0L;
    }

    public long notifyOfEvent(RemoteDependencyNotification_TL remoteDependencyNotification_TL, long l) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the notifyOfEvent method should not be called on a Schedule type remote server.");
    }

    private RemoteObject[] getJobs() throws ResourceUnavailableException {
        return this.getJobs(null, 0, 0);
    }

    private RemoteObject[] getJobs(String string, int n, int n2) throws ResourceUnavailableException {
        String string2;
        String string3;
        int n3;
        ArrayList<RemoteObject> arrayList = new ArrayList<RemoteObject>();
        String string4 = "JOB_0";
        if (this.checkName(string4, string)) {
            for (n3 = 0; n3 < 3; ++n3) {
                string3 = String.valueOf(n3);
                string2 = "description of " + string4;
                arrayList.add(new RemoteObject((Object)string3, string4, string2));
            }
        }
        for (n3 = arrayList.size() + 1; n3 < 500; ++n3) {
            string3 = String.valueOf(n3);
            string4 = "JOB_" + string3;
            string2 = "description of " + string4;
            if (!this.checkName(string4, string)) continue;
            arrayList.add(new RemoteObject((Object)string3, string4, string2));
        }
        RemoteObject[] remoteObjectArray = new RemoteObject[]{};
        remoteObjectArray = arrayList.toArray(remoteObjectArray);
        if (n == 0) {
            return remoteObjectArray;
        }
        ArrayList<RemoteObject> arrayList2 = new ArrayList<RemoteObject>();
        for (int i = n2; i < n2 + n; ++i) {
            if (remoteObjectArray.length < i + 1) continue;
            arrayList2.add(remoteObjectArray[i]);
        }
        return arrayList2.toArray(new RemoteObject[0]);
    }

    private boolean checkName(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        return string.startsWith(string2);
    }

    private RemoteObject[] getGroupJobs() throws ResourceUnavailableException {
        return this.getGroupJobs(null, 0, 0);
    }

    private RemoteObject[] getGroupJobs(String string, int n, int n2) throws ResourceUnavailableException {
        String string2;
        int n3;
        ArrayList<RemoteObject> arrayList = new ArrayList<RemoteObject>();
        String string3 = "GROUP_000";
        String string4 = "";
        if (this.checkName(string3, string)) {
            for (n3 = 0; n3 < 3; ++n3) {
                string2 = String.valueOf(n3);
                string4 = "description of " + string3;
                arrayList.add(new RemoteObject((Object)string2, string3, string4));
            }
        }
        for (n3 = arrayList.size() + 1; n3 < 500; ++n3) {
            string2 = String.valueOf(n3);
            string3 = "GROUP_" + string2;
            string4 = "description of " + string3;
            if (!this.checkName(string3, string)) continue;
            arrayList.add(new RemoteObject((Object)string2, string3, string4));
        }
        RemoteObject[] remoteObjectArray = new RemoteObject[]{};
        remoteObjectArray = arrayList.toArray(remoteObjectArray);
        if (n == 0) {
            return remoteObjectArray;
        }
        ArrayList<RemoteObject> arrayList2 = new ArrayList<RemoteObject>();
        for (int i = n2; i < n2 + n; ++i) {
            if (remoteObjectArray.length < i + 1) continue;
            arrayList2.add(remoteObjectArray[i]);
        }
        return arrayList2.toArray(new RemoteObject[0]);
    }

    private boolean isInArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private boolean isInstalled() throws ResourceUnavailableException {
        return true;
    }

    private void validateInstall() throws RemoteServerNotConfiguredException, ResourceUnavailableException {
        if (!this.isInstalled()) {
            throw new RemoteServerNotConfiguredException();
        }
    }

    private void validateRemoteEventType(RemoteEventType remoteEventType) {
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        if (!this.isInArray(this.getNotifiableEventTypes(), remoteEventType.persistanceCode())) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
        }
    }

    public List<RBTNotification> getNotificationList(long l, int n) {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)(" =============== Remote Server Simulator.getNotificationList: " + l + "/" + n));
        logger.warn((Object)" ===============================================================================================");
        return null;
    }

    public void removeNotificationById(long l) {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)(" =============== Remote Server Simulator.removeNotificationById: " + l));
        logger.warn((Object)" ===============================================================================================");
    }

    public int removeDependency(long l, RemoteEventType remoteEventType, long l2) throws ResourceUnavailableException {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)(" =============== Remote Server Simulator.removeDependency: " + l + "/" + remoteEventType + "/" + l2));
        logger.warn((Object)" ===============================================================================================");
        return 0;
    }

    public int removeDependency(int n, long l, long l2) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the removeDependency method should not be called on a Schedule type remote server.");
    }

    public RegisteredServer[] getRegisteredServers(RemoteServer remoteServer) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        logger.warn((Object)" ===============================================================================================");
        logger.warn((Object)(" =============== Remote Server Simulator.getRegisteredServers: " + remoteServer.getName()));
        logger.warn((Object)" ===============================================================================================");
        return new RegisteredServer[0];
    }
}

