/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.tray;

import com.helpsystems.common.core.dm.IApplicationConfigManager;
import com.helpsystems.enterprise.tray.ServerEntryConfigDialog;
import com.helpsystems.enterprise.tray.ServiceFrame;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class AgentFileFinder {
    private static final String PROPERTY = "LAST_DIRECTORY_CHOSEN";
    private static File lastFileChooserDirectory = null;
    private Window parent;

    public AgentFileFinder(Window window) {
        this.parent = window;
        lastFileChooserDirectory = new File(ServerEntryConfigDialog.DEFAULT_PATH_ENTRY);
        String string = this.getLastPath();
        if (string != null) {
            lastFileChooserDirectory = new File(string);
        }
    }

    public String showFileFinder(String string, boolean bl) {
        File file = null;
        if (string != null && string.trim().length() > 0 && (file = new File(string)) != null) {
            lastFileChooserDirectory = file;
        }
        JFileChooser jFileChooser = null;
        String string2 = "Select";
        if (!bl) {
            jFileChooser = this.getFileChooser();
        } else {
            jFileChooser = this.getSaveFileChooser();
            string2 = "Save";
        }
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showDialog(this.parent, string2);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            String string3 = this.doAddXMLExtensionThing(file2);
            this.setFileChosen(string3);
            return string3;
        }
        return null;
    }

    public String getNewFullFileName(String string) {
        if (string.indexOf(File.separator) != -1) {
            if (string.toLowerCase().contains(".xml")) {
                return string;
            }
            return string + "." + "xml";
        }
        String string2 = lastFileChooserDirectory + File.separator + string;
        if (string2.indexOf(".") == -1) {
            return string2 + "." + "xml";
        }
        return string2;
    }

    private String doAddXMLExtensionThing(File file) throws HeadlessException {
        if (!file.exists() && file.getName().indexOf(".") == -1) {
            return new File(file.getPath() + "." + "xml").getPath();
        }
        return file.getPath();
    }

    private JFileChooser getFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText("Select");
        jFileChooser.setDialogTitle("Select an existing Agent XML file");
        jFileChooser.setMinimumSize(new Dimension(350, 350));
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML Document (*.xml)";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        if (lastFileChooserDirectory != null) {
            jFileChooser.setCurrentDirectory(lastFileChooserDirectory);
        }
        return jFileChooser;
    }

    private JFileChooser getSaveFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText("Save");
        jFileChooser.setDialogTitle("Save new Agent XML file");
        jFileChooser.setMinimumSize(new Dimension(350, 350));
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "XML Document (*.xml)";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        if (lastFileChooserDirectory != null) {
            jFileChooser.setCurrentDirectory(lastFileChooserDirectory);
        }
        return jFileChooser;
    }

    private void setFileChosen(String string) {
        if (string == null) {
            throw new NullPointerException("Directory name cannot be null.");
        }
        File file = new File(string);
        if ((file = file.getParentFile()) != null && file.isDirectory()) {
            lastFileChooserDirectory = file;
            this.saveLastPath(file.getAbsolutePath());
        }
    }

    private String getLastPath() {
        IApplicationConfigManager iApplicationConfigManager = ServiceFrame.getConfigurationManager();
        if (iApplicationConfigManager != null) {
            return iApplicationConfigManager.getProperty(PROPERTY);
        }
        return null;
    }

    private void saveLastPath(String string) {
        IApplicationConfigManager iApplicationConfigManager = ServiceFrame.getConfigurationManager();
        if (iApplicationConfigManager != null) {
            if (string == null) {
                iApplicationConfigManager.setProperty(PROPERTY, "");
            } else {
                iApplicationConfigManager.setProperty(PROPERTY, string);
            }
        }
    }

    public static String getFileName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n > -1) {
            return string2.substring(0, n);
        }
        return string2.trim();
    }
}

