/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.client.util.GuiLogging;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.peer.DefaultConfigPath;
import com.helpsystems.enterprise.service.AgentServiceAMImpl;
import com.helpsystems.enterprise.service.AgentServiceConfig;
import com.helpsystems.enterprise.service.ServicePeer;
import com.helpsystems.enterprise.tray.SystemTrayControl;
import java.io.File;
import org.apache.log4j.Logger;

public class AgentService {
    private static final Logger logger = Logger.getLogger(AgentService.class);
    public static final String INTERNAL_PRODUCT_NAME = "Automate Schedule";
    public static final String INTERNAL_SHORT_NAME = "Automate service_manager";

    public static void main(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = true;
        String string = DefaultConfigPath.getDefaultPath() + File.separator + "agentService.config";
        if (stringArray.length > 0) {
            if ("-s".equals(stringArray[0])) {
                bl = false;
                bl2 = false;
            } else if ("-n".equals(stringArray[0])) {
                bl = true;
                bl2 = false;
            } else {
                string = stringArray[0];
            }
        }
        File file = new File(string);
        AgentServiceConfig agentServiceConfig = AgentServiceAMImpl.loadOrCreateConfig(file);
        if (bl) {
            GuiLogging.startLogging((String)"Automate service_manager.log", (String)INTERNAL_PRODUCT_NAME);
            GuiLogging.setLoggingLevel((String)"logging-trace");
            SystemTrayControl.initialize(agentServiceConfig.getLocalListenPort(), bl2);
        } else {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            AgentServiceAMImpl agentServiceAMImpl = new AgentServiceAMImpl(string);
            ManagerRegistry.registerManager((IAbstractManager)agentServiceAMImpl);
            try {
                new ServicePeer(agentServiceAMImpl, agentServiceConfig.getLocalListenPort());
            }
            catch (Exception exception) {
                logger.fatal((Object)"Unable to start the ServicePeer", (Throwable)exception);
            }
        }
    }

    public static void stopAgentService(String[] stringArray) {
        logger.info((Object)"Stopping the agent service...");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                logger.debug((Object)("\tEnding parameter " + (i + 1) + ": " + stringArray[i]));
            }
        }
    }
}

